/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
*\ingroup post_correlation
*\defgroup correction_topo Topography correction (used with ROIPAC)
*/

/**
*\ingroup correction_topo
*\file iff_correction_topo.h
*\author Yajing Yan
*
*\brief operator of topographic correction
*
*file includes structures, prototypes of function of the operator correction_topo
*
*/

#ifndef IFF_CORRECTION_TOPO_H
#define IFF_CORRECTION_TOPO_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"


/**
*\ingroup correction_topo
*\fn void correction_topo(EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputTopo,EFIDIRImage outputImage,EFIDIRImage outputMask);
*\brief function of correction of an effect
* function that correct the effect like the topography from a image of a different scale
*
*\param inputImage is the image to correct
*\param inputMask is the mask of the image to correct
*\param inputTopo is the image containing the information of effect to correct
*\param outputImage is the result of the correction
*\param outputMask is the mask of the image after correction
*
*/
void correction_topo(EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputTopo,EFIDIRImage outputImage,EFIDIRImage outputMask);

#endif
