/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
*\ingroup post_correlation
*\defgroup correction_ramp Substract an effect of ramp from the image data
*/

/**
*\ingroup correction_ramp
*\file iff_correction_ramp.h
*\author Yajing Yan
*
*\brief operator of correction of an effect of ramp
*
*file includes structures, prototypes of function of the operator correction_ramp
*
*/

#ifndef IFF_CORRECTION_RAMP_H
#define IFF_CORRECTION_RAMP_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"
#include "efidir_matrix_op.h"

/**
*\ingroup correction_ramp
*\fn void correction_ramp(EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask, char *input_file);
*\brief funcion of correction of a ramp
*function subtracting a ramp in the image
*
*\param inputImage is the image before the correction
*\param inputMask is the mask of the image before the correction
*\param inputConf is the image of confidence of the image before the correction
*\param inputConfMask is the mask of the image of confidence
*\param outputImage is the image after the correction
*\param outputMask is the mask of the image after the correction
*\param input_file is the file containing the positions and the sizes of the windows
*
*/
void correction_ramp(EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask, char *input_file);

#endif

