/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup divers
 * \defgroup correction_parabola parabolic correction of image
 */
/**
 * \ingroup correction_parabola
 * \file iff_correction_parabola.h
 * \author Yajing Yan
 * 
 * \brief operator of generation parabola correction
 * 
 * file includes (stucture, prototype de fonction) of the operator correction_parabola
 * 
 * 
 */

#ifndef IFF_CORRECTION_PARABOLA_H
#define IFF_CORRECTION_PARABOLA_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"


/**
 * \ingroup correction_parabola
 * \typedef Correction_parabola_param
 *
 * \brief reference on correction_parabola_param structure
 *
 */
/**
 * \ingroup correction_parabola
 * \struct correction_parabola_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_correction_parabola_param{
  int index; /*!< processing index */
}correction_parabola_param, *Correction_parabola_param;

/**
 * \ingroup correction_parabola
 * \fn Correction_parabola_param new_correction_parabola_param()
 *
 * \return A new reference on allocated correction_parabola_param structure
 *
 * \brief Create a new Correction_parabola_param reference 
 *
 */
static Correction_parabola_param new_correction_parabola_param();
/**
 * \ingroup correction_parabola
 * \fn void free_correction_parabola_param(Correction_parabola_param p)
 *
 * \param p A reference on a correction_parabola_param structure
 *
 * \brief Free an allocated Correction_parabola_param reference 
 *
 */
void free_correction_parabola_param(Correction_parabola_param p);


/**
 * \ingroup correction_parabola
 * \fn void define_correction_parabola_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_correction_parabola_param(char *extra_description);

/**
 * \ingroup correction_parabola
 * \fn Correction_parabola_param get_correction_parabola_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Correction_parabola_param that contains the parameters.
 */
Correction_parabola_param get_correction_parabola_param();


/**
 * \ingroup correction_parabola
 * \fn void correction_parabola(Correction_parabola_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, char *file, EFIDIRImage outputImage);
 * \brief function of parabolic correction of an image
 * Function allowing to correct a parabolic effect from an image
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the input image
 * \param inputMask is the mask associated with the input image
 * \param file is the sliding window location file
 * \param outputImage is the image after correction
 *
 */
void correction_parabola(Correction_parabola_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, char *file, EFIDIRImage outputImage);


#endif
