/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup post_correlation
 * \defgroup constant_correction Substract a constant from the image data
 */

/**
*\ingroup constant_correction
*\file iff_constant_correction.h
*\author Yajing Yan
*
*\brief operator of constant correction
*
* file includes structures, prototypes of funcion of the operator constant_correction
*
*/

#ifndef IFF_CONSTANT_CORRECTION_H
#define IFF_CONSTANT_CORRECTION_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"


/**
*\ingroup constant_correction
*\fn void constant_correction(EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf, EFIDIRImage inputConfMask,EFIDIRImage outputImage, EFIDIRImage outputMask, char *input_file);
*\brief function of elimination of a constant in the image
* function that subtracts a constant for every pixel in the image
* This constant comes from the mean value weighted by the confidence of several windows
*
*\param inputImage is the image before the correction
*\param inputMask is the mask of the image before the correction
*\param inputConf is the confidence image of the image before the correction
*\param inputConfMask is the mask of the confidence image
*\param outputImage is the image after the correction
*\param outputMask is the mask of the image after the correction
*\param input_file is the file in which we define the position and the size of the windows 
*
*/
void constant_correction(EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf, EFIDIRImage inputConfMask,EFIDIRImage outputImage, EFIDIRImage outputMask, char *input_file);

#endif

