/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup 3D_inversion
 * \defgroup composite_surfdisp Construct composed displacements of projection with selected projections
 */
/**
 * \ingroup composite_surfdisp
 * \file iff_composite_surfdisp.h
 * \author Yajing Yan
 * 
 * \brief operator of constructing the displacements composites images from selected projections
 * 
 * file includes (stucture, prototype de fonction) of the operator composite_surfdisp
 * 
 * 
 */

#ifndef IFF_COMPOSITE_SURFDISP_H
#define IFF_COMPOSITE_SURFDISP_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"


/**
 * \ingroup composite_surfdisp
 * \typedef Composite_surfdisp_param
 *
 * \brief reference on composite_surfdisp_param structure
 *
 */
/**
 * \ingroup composite_surfdisp
 * \struct composite_surfdisp_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_composite_surfdisp_param
{
  float X_min; /*!< first coordonate in X to process */
  float Y_min; /*!< first coordonate in Y to process */
  float X_max; /*!< last coordonate in X to process */
  float Y_max; /*!< last  coordonate in Y to process */
  int nb; /*!< number of projections */
}composite_surfdisp_param, *Composite_surfdisp_param;

/**
 * \ingroup composite_surfdisp
 * \fn new_composite_surfdisp_param()
 *
 * \return A new reference on allocated composite_surfdisp_param structure
 *
 * \brief Create a new Composite_surfdisp_param reference 
 *
 */
static Composite_surfdisp_param new_composite_surfdisp_param();
/**
 * \ingroup composite_surfdisp
 * \fn free_composite_surfdisp_param(Composite_surfdisp_param p)
 *
 * \param p A reference on a composite_surfdisp_param structure
 *
 * \brief Free an allocated Composite_surfdisp_param reference 
 *
 */
void free_composite_surfdisp_param(Composite_surfdisp_param p);


/**
 * \ingroup composite_surfdisp
 * \fn void define_composite_surfdisp_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_composite_surfdisp_param(char *extra_description);

/**
 * \ingroup composite_surfdisp
 * \fn Composite_surfdisp_param get_composite_surfdisp_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Composite_surfdisp_param that contains the parameters.
 */
Composite_surfdisp_param get_composite_surfdisp_param();

/**
 * \ingroup composite_surfdisp
 * \fn void composite_surfdisp(Composite_surfdisp_param p, EFIDIRImage *def, EFIDIRImage *mask, EFIDIRImage *error, EFIDIRImage *disp, EFIDIRImage *sigma);
 * \brief function of calculating the selected composite AA, AR, DA, DR projection images
 * Function allowing to calculate the selected composite AA, AR, DA, DR projection images
 *
 * \param p is the structure of the parameters for the operator 
 * \param def is the different projections of deformation
 * \param mask is the masks of different projections of deformation
 * \param error is the uncertainty image of different projections of deformation
 * \param disp is the composite (DR, DA, AR, AA) images
 * \param sigma is the associated uncertainty images
 * 
 */
void composite_surfdisp(Composite_surfdisp_param p, EFIDIRImage *def, EFIDIRImage *mask, EFIDIRImage *error, EFIDIRImage *disp, EFIDIRImage *sigma);

#endif
