/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup 3D_inversion
 * \defgroup composite_offset Construct projection displacements series in the same grid
 */
/**
 * \ingroup composite_offset
 * \file iff_composite_offset.h
 * \author Yajing Yan
 * 
 * \brief operator of constructing the projection displacements series in the same grid
 * 
 * file includes (stucture, prototype de fonction) of the operator composite_offset
 * 
 * 
 */

#ifndef IFF_COMPOSITE_OFFSET_H
#define IFF_COMPOSITE_OFFSET_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"


/**
 * \ingroup composite_offset
 * \typedef Composite_offset_param
 *
 * \brief reference on composite_offset_param structure
 *
 */
/**
 * \ingroup composite_offset
 * \struct composite_offset_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_composite_offset_param
{
  float X_min; /*!< first coordonate in X to process */
  float Y_min; /*!< first coordonate in Y to process */
  float X_max; /*!< last coordonate in X to process */
  float Y_max; /*!< last  coordonate in Y to process */
  int nb; /*!< number of projections */
}composite_offset_param, *Composite_offset_param;

/**
 * \ingroup composite_offset
 * \fn new_composite_offset_param()
 *
 * \return A new reference on allocated composite_offset_param structure
 *
 * \brief Create a new Composite_offset_param reference 
 *
 */
static Composite_offset_param new_composite_offset_param();
/**
 * \ingroup composite_offset
 * \fn free_composite_offset_param(Composite_offset_param p)
 *
 * \param p A reference on a composite_offset_param structure
 *
 * \brief Free an allocated Composite_offset_param reference 
 *
 */
void free_composite_offset_param(Composite_offset_param p);


/**
 * \ingroup composite_offset
 * \fn void define_composite_offset_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_composite_offset_param(char *extra_description);

/**
 * \ingroup composite_offset
 * \fn Composite_offset_param get_composite_offset_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Composite_offset_param that contains the parameters.
 */
Composite_offset_param get_composite_offset_param();

/**
 * \ingroup composite_offset
 * \fn void composite_offset(Composite_offset_param p, EFIDIRImage *def, EFIDIRImage *mask, EFIDIRImage *error, EFIDIRImage *disp, EFIDIRImage *sigma);
 * \brief function of constructing the projection displacement images in the same grid
 * Function allowing to construct the projection displacement images in the same grid
 *
 * \param p is the structure of the parameters for the operator 
 * \param def is the different projections of deformation
 * \param mask is the masks of different projections of deformation
 * \param error is the uncertainty image of different projections of deformation
 * \param disp is the projection image series
 * \param sigma is the associated uncertainty images
 * 
 */
void composite_offset(Composite_offset_param p, EFIDIRImage *def, EFIDIRImage *mask, EFIDIRImage *error, EFIDIRImage *disp, EFIDIRImage *sigma);

#endif
