/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup interferometry
* \defgroup compare Compare the displacement obtained by correlation and DInSAR using a sliding window
*/

/**
* \ingroup compare
* \file iff_compare.h
* \author Yajing Yan
*
* \brief operator of comparison of two displacement images by a sliding window
*
* file includes structures,prototypes of function of the operator compare
*
*/

#ifndef IFF_COMPARE_H
#define IFF_COMPARE_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"


/**
* \ingroup compare
* \typedef typedef Compare_param
*
* \brief structure that contains the parameters of the operator
*
*/
typedef struct struct_compare_param
{
  int size; /*!< size of sliding window */
  int shiftx; /*!< shift of columns of slave image with respect to master image */
  int shifty; /*!< shift of lines of slave image with respect to master image */
  int index; /*!< processing index */
}compare_param,*Compare_param;

/**
 * \ingroup compare
 * \fn Compare_param new_compare_param();
 *
 * \return A new reference on allocated compare_param structure
 *
 * \brief Create a new Compare_param reference
 *
 */

static Compare_param new_compare_param();

/**
 * \ingroup compare
 * \fn void free_compare_param(Compare_param p);
 *
 * \param p A reference on a compare_param structure
 *
 * \brief Free an allocated Compare_param reference
 *
 */

void free_compare_param(Compare_param p);

/**
* \ingroup compare
* \fn void define_compare_param(char *extra_description);
* \brief Default edifir function that defines parameters
*
* \param extra_description Extra description for multi definition of the same parameter(NULL is accepted)
*
*/
 void define_compare_param(char *extra_description);

/**
* \ingroup compare
* \fn Compare_param get_compare_param();
* \brief Default edifir function that gets parameters
*
* \return A Compare_param that contains the parameters
*
*/
Compare_param get_compare_param();


/**
 * \ingroup compare
 * \fn void compare(Compare_param p, EFIDIRImage MasterImage, EFIDIRImage MasterMask, EFIDIRImage SlaveImage, EFIDIRImage SlaveMask, EFIDIRImage outputImage);
 * \brief function that displays an image from a ASCII file
 *
 * \param p operator parameters
 * \param MasterImage is the master image
 * \param MasterMask is the mask of master image
 * \param SlaveImage is the slave image
 * \param SlaveMask is the mask of slave image
 * \param outputImage is the image to display
 *
 */
void compare(Compare_param p, EFIDIRImage MasterImage, EFIDIRImage MasterMask, EFIDIRImage SlaveImage, EFIDIRImage SlaveMask, EFIDIRImage outputImage);

#endif
