/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup infos_fusion
 * \defgroup blue Best Linear Unbiased Estimator
 */
/**
 * \ingroup blue
 * \file iff_blue.h
 * \author Yajing Yan
 * 
 * \brief best linear unbiased estimator
 * 
 * file includes (stucture, prototype de fonction) of the operator blue
 * 
 * 
 */

#ifndef IFF_BLUE_H
#define IFF_BLUE_H

#include <stdio.h>
#include<stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"


/**
 * \ingroup blue
 * \typedef Blue_param
 *
 * \brief reference on blue_param structure
 *
 */
/**
 * \ingroup blue
 * \struct blue_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_blue_param{
  float Xstart; /*!< first column to process */
  float Ystart;  /*!< first line to process */
  float Xover;  /*!< last column to process */
  float Yover;  /*!< last line to process */
}blue_param, *Blue_param;

/**
 * \ingroup blue
 * \fn new_blue_param()
 *
 * \return A new reference on allocated blue_param structure
 *
 * \brief Create a new Blue_param reference
 *
 */
static Blue_param new_blue_param();
/**
 * \ingroup blue
 * \fn free_blue_param(Blue_param p)
 *
 * \param p A reference on a blue_param structure
 *
 * \brief Free an allocated Blue_param reference
 *
 */
void free_blue_param(Blue_param p);

/**
 * \ingroup blue
 * \fn void define_blue_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_blue_param(char *extra_description);

/**
 * \ingroup blue
 * \fn Blue_param get_blue_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Blue_param that contains the parameters.
 */
Blue_param get_blue_param();

/**
 * \ingroup blue
 * \fn void blue(Blue_param p, EFIDIRImage *def_series, EFIDIRImage *mask_series, EFIDIRImage *error_series, int nb, EFIDIRImage outputdef, EFIDIRImage outputmask, EFIDIRImage outputerror);
 * \brief function of data assimilation
 * Function allowing to assimilate a series of measurements
 *
 * \param p is the structure of the parameters for the operator
 * \param def_series is the deformation image series of different Tracks
 * \param mask_series is the mask series
 * \param error_series is the uncertainty associated with deformation measurement
 * \param nb is the number of image in the series
 * \param outputdef is the image after assimilation
 * \param outputmask is the mask associated with image to output
 * \param outputerror is the uncertainty of image to output
 *
 */

void blue(Blue_param p, EFIDIRImage *def_series, EFIDIRImage *mask_series, EFIDIRImage *error_series, int nb, EFIDIRImage outputdef, EFIDIRImage outputmask, EFIDIRImage outputerror);


#endif
