/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup divers
 * \defgroup autocorrelation Auto correlation calculation
 */
/**
 * \ingroup autocorrelation
 * \file iff_autocorrelation.h
 * \author Yajing Yan (LISTIC, IsTerre)
 * 
 * \brief operator of auto correlation
 * 
 * file includes (stucture, prototype de fonction) of the operator autocorrelation
 * 
 * 
 */

#ifndef IFF_AUTOCORRELATION_H
#define IFF_AUTOCORRELATION_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_math.h"

/**
 * \ingroup autocorrelation
 * \typedef Autocorrelation_param
 *
 * \brief reference on autocorrelation_param structure
 *
 */
/**
 * \ingroup autocorrelation
 * \struct autocorrelation_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_autocorrelation_param{
  int min; /*!< maximum distance of auto correlation */
  int max; /*!< minimum distance of auto correlation */
  int step; /*!< step of increment */
}autocorrelation_param, *Autocorrelation_param;

/**
 * \ingroup autocorrelation
 * \fn Autocorrelation_param new_autocorrelation_param()
 *
 * \return A new reference on allocated autocorrelation_param structure
 *
 * \brief Create a new Autocorrelation_param reference 
 *
 */
static Autocorrelation_param new_autocorrelation_param();
/**
 * \ingroup autocorrelation
 * \fn void free_autocorrelation_param(Autocorrelation_param p)
 *
 * \param p A reference on a autocorrelation_param structure
 *
 * \brief Free an allocated Autocorrelation_param reference 
 *
 */
void free_autocorrelation_param(Autocorrelation_param p);


/**
 * \ingroup autocorrelation
 * \fn void define_autocorrelation_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_autocorrelation_param(char *extra_description);

/**
 * \ingroup autocorrelation
 * \fn Autocorrelation_param get_autocorrelation_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Autocorrelation_param that contains the parameters.
 */
Autocorrelation_param get_autocorrelation_param();

/**
 * \ingroup autocorrelation
 * \fn void autocorrelation(Autocorrelation_param p, EFIDIRImage input, EFIDIRImage mask, char *file);
 * \brief function of auto-correlation
 * Function allowing to compute auto-correlation
 *
 * \param p is the structure of the parameters for the operator
 * \param input is the input image
 * \param mask is the mask
 * \param file is the output file containing the distance and covariance
 *
 */

void autocorrelation(Autocorrelation_param p, EFIDIRImage input, EFIDIRImage mask, char *file);


#endif
