/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup divers
* \defgroup adapt_smoothing Smooth the far field for quadtree sampling
*/

/**
* \ingroup adapt_smoothing
* \file iff_adapt_smoothing.h
* \author Yajing Yan
*
* \brief operator of adaptive smoothing
*
* file includes structures, prototypes of function of the operator adapt_smoothing
*
*/

#ifndef IFF_ADAPT_SMOOTHING_H
#define IFF_ADAPT_SMOOTHING_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"

#include "com_filter_median.h"

/**
 * \ingroup adapt_smoothing
 * \typedef Adapt_smoothing_param
 *
 * \brief reference on adapt_smoothing_param structure
 *
 */

/**
 * \ingroup adapt_smoothing
 * \struct adapt_smoothing_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_adapt_smoothing_param{
  int nb; /*!< number of regions */
  int *xstart; /*!< first column of image to process */
  int *ystart; /*!< first line of image to process */
  int *nbx; /*!< number of columns of image to process */
  int *nby; /*!< number of lines of image to process */
  int size; /*!< size of sliding window */
}adapt_smoothing_param, *Adapt_smoothing_param;

/**
 * \ingroup adapt_smoothing
 * \fn new_adapt_smoothing_param()
 *
 * \return A new reference on allocated adapt_smoothing_param structure
 *
 * \brief Create a new Adapt_smoothing_param reference 
 *
 */
static Adapt_smoothing_param new_adapt_smoothing_param();

/**
 * \ingroup adapt_smoothing
 * \fn free_adapt_smoothing_param(Adapt_smoothing_param p)
 *
 * \param p A reference on a adapt_smoothing_param structure
 *
 * \brief Free an allocated Adapt_smoothing_param reference 
 *
 */
void free_adapt_smoothing_param(Adapt_smoothing_param p);


/**
 * \ingroup adapt_smoothing
 * \fn void define_adapt_smoothing_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_adapt_smoothing_param(char *extra_description);

/**
 * \ingroup adapt_smoothing
 * \fn Adapt_smoothing_param get_adapt_smoothing_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Adapt_smoothing_param that contains the parameters.
 */
Adapt_smoothing_param get_adapt_smoothing_param();


/**
* \ingroup adapt_smoothing
* \fn void adapt_smoothing(Adapt_smoothing_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage);
* \brief function of adaptive smoothing
* function allowing to smooth the far filed for quadtree sampling
*
* \param p is the structure of the parameters for the operator
* \param inputImage is the image to be smoothed
* \param inputMask is the mask of image to be smoothed
* \param outputImage is the image after the smoothing
*
*/
void adapt_smoothing(Adapt_smoothing_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage);

#endif

