/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup geotrans
 * \defgroup utm2latlon Convert UTM to LAT/LON
 */
/**
 * \ingroup utm2latlon
 * \author Yajing Yan (LISTIC)
 *
 */

#ifndef COM_UTM2LATLON_H
#define COM_UTM2LATLON_H

#include "efidir_param.h"
#include <stdlib.h> 
#include <math.h>



/**
 * \ingroup utm2latlon
 * \fn void utm2latlon(double North, double East, double long0, double lat, double lon);
 * \brief Convert UTM to LAT/LON system
 *
 * \param North is the North component in UTM system
 * \param East is the East component in UTM system (relative to central meridian, subtract 500000 from conventional UTM coordinate)
 * \param long0 is the reference longitude
 * \param lat is the latitude in Geographic system
 * \param lon is the longitude in Geographic system
 *
 */
void utm2latlon(double North, double East, double long0, double lat, double lon);

#endif 
