/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef EFIDIR_PARAM_TYPE_H
#define EFIDIR_PARAM_TYPE_H

#include "efidir_goodies.h"

#ifdef __XML2__
#include <libxml/xmlreader.h>
#endif

/**
 * \ingroup param_manager
 * \enum enum_param_type Param_type
 * \brief parameter types allowed by the parameter manager.
 *
 */
#define NOTYPE 0
typedef enum enum_param_type { 
  INT=1,      /*!< Integer type. */
  LONG,      /*!< Long Integer type. */
  FLOAT,    /*!< Floating point single precision type. */
  DOUBLE,   /*!< Floating point double precision type. */
  CHAR,     /*!< Character type. */
  STRING    /*!< String (char*) type. */ 
} Param_type;
static char *param_type_string[] = {"no type", "int", "long", "float", "double", "char", "string"};

#define NOIO 0
typedef enum enum_param_io { 
  IN=1,      /*!< Input parameter. */
  OUT,      /*!< Output parameter. */
} Param_io;
static char *param_io_string[] = {"no I/O defined", "input", "output"};

typedef enum enum_param_optional {
  REQUIRED = false, /* parameter is required. */
  OPTIONAL = true, /* parameter is optional. */
} Param_optional;

typedef enum enum_param_series {
  SINGLE = false, /* parameter is single */
  SERIES = true, /* parameter is series of values */
}Param_series;

typedef struct struct_param_manager{
  char *identifier;
  char *string_value;
  union {
    int int_value;
    long long_value;
    double double_value;
    char char_value;
    char *string_value;
  } value;
  int type;
  int io;
  char *description;
  bool optional;
  bool series;
  union {
    int *int_values;
    long *long_values;
    double *double_values;
    char *char_values;
    char **string_values;
  } values;
  int number_of_values;

  int rang;  // rang band le niveau de param
  int order; // ordre de definition pour mode interactif
  struct struct_param_manager *next;
  struct struct_param_manager *prev;
  struct struct_param_manager *up;
  struct struct_param_manager *down;
}param_manager, *Param_manager;
#endif
