/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef EFIDIR_PARAM_SERIES_H
#define EFIDIR_PARAM_SERIES_H

#include <regex.h>
#include <string.h>

#include "efidir_param_type.h"
/*
set: value1, value2, ... valuen
seq: [1st_value:last_value]
seq: [1st_value:last_value:step]
setseq: value[seq], value2[seq], ... 
 */
int __set_string_value_2_int_values(Param_manager param);
int __set_string_value_2_integer_values(Param_manager param);
int __set_string_value_2_floating_values(Param_manager param);
int __set_string_value_2_double_values(Param_manager param);
int __set_string_value_2_char_values(Param_manager param);
int __set_string_value_2_string_values(Param_manager param);

int __convert_list2integer_list(Param_manager param);
int __convert_list2floating_list(Param_manager param);
int __convert_list2char_list(Param_manager param);
int __convert_list2string_list(Param_manager param);

#endif
