/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup efidir_math_tools
 * \defgroup cal_matrix some operations of matrix
 */
/**
 * \ingroup cal_matrix
 * \file efidir_matrix_op.h
 * \author Yajing Yan
 * 
 * \brief operator of matrix.
 * 
 * file includes (stucture, prototype de fonction) of the operator cal_matrix
 * 
 * 
 */

#ifndef EFIDIR_CAL_MATRIX_H
#define EFIDIR_CAL_MATRIX_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "efidir_goodies.h"
#include "efidir_math.h"


/**
 * \ingroup cal_matrix
 * \fn void transpose_matrix(float **mat, int l, int c, float **mat_trans);
 * \brief function of tranposing a matrix
 * Function for calculating the transpose of a matrix
 *
 * \param mat is the matrix whose transpose we need
 * \param l is the number of lines of the matrix
 * \param c is the number of columns of the matrix
 * \param mat_trans is the transposed matrix
 *
 */
void transpose_matrix(float **mat, int l, int c,float **mat_trans );

/**
 * \ingroup cal_matrix
 * \fn void transpose_db(double **mat, int l, int c, double **mat_trans);
 * \brief function of tranposing a double matrix
 * Function for calculating the transpose of a double matrix
 *
 * \param mat is the matrix whose transpose we need
 * \param l is the number of lines of the matrix
 * \param c is the number of columns of the matrix
 * \param mat_trans is the transposed matrix
 *
 */
void transpose_db(double **mat, int l, int c,double **mat_trans );


/**
 * \ingroup cal_matrix
 * \fn void inverse(double **mat, int l, int c, double **mat_inv);
 * \brief function of inverting a double matrix
 * Function for calculating the inverse of a double matrix
 *
 * \param mat is the matrix to invert
 * \param l is the number of lines of the matrix
 * \param c is the number of columns of the matrix
 * \param mat_inv is the inversed matrix
 *
 */
void inverse(double **mat, int l, int c, double **mat_inv);


/**
 * \ingroup cal_matrix
*\fn void linear_equation(double **a,double *b,double *x,int m);
*\brief function of the resolution of a linear equation system by a least square method
* function looking for the root of a linear equation system like ax=b
*
*\param a is a 2 dimension matrix that represents the left part of the equation
*\param b is a 1 dimension matrix that represents the right part of the equation
*\param x is a 1 dimension matrix that represents the root of the equation
*\param m is the size of the matrix
*
*/
void linear_equation(double **a,double *b,double *x,int m);

#endif
