/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup geotrans
 * \defgroup latlon2utm Convert LAT/LON to UTM
 */
/**
 * \ingroup latlon2utm
 * \author Yajing Yan (LISTIC)
 *
 */

#ifndef EFIDIR_LATLON2UTM_H
#define EFIDIR_LATLON2UTM_H

#include "efidir_param.h"
#include <stdlib.h> 
#include <math.h>
#include "efidir_file_txt.h"
#include "efidir_math.h"



/**
 * \ingroup latlon2utm
 * \fn void latlon2utm(double phi, double lambda, double lambda0, int hemis, double *E, double *N);
 * \brief Convert LAT/LON to UTM system
 *
 * \param phi is the latitude of a point
 * \param lambda is the longitude of a point
 * \param lambda0 is the longitude of reference
 * \param hemis is the index of hemisphere, 1 NORTH, 2 SOUTH
 * \param E is the Esting of UTM
 * \param N is the Northing of UTM
 *
 */
void latlon2utm(double phi, double lambda, double lambda0, int hemis, double *E, double *N);

#endif 
