/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \ingroup common 
 * \defgroup half_float Half Float
 * \file efidir_half_float.h
 * \author Flavien Vernier (LISTIC)
 * 
 * \brief EFIDIR half float manager (IEEE 754-2008)
 */

#ifndef __EFIDIR_HALF_FLOAT_H__
#define __EFIDIR_HALF_FLOAT_H__


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "efidir_assert.h"

#define half short


/**
 * \ingroup half_float
 * \fn half f2hIEEE(float f); 
 * \brief convert a float to IEEE half float
 *
 * \param f the float
 * \return the half float
 */
half f2hIEEE(float f); 

/**
 * \ingroup half_float
 * \fn float hIEEE2f(half hf);
 * \brief convert a IEEE half float to float
 *
 * \param hf the half float
 * \return the float
 */
float hIEEE2f(half hf);


#endif
