/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup efidir 
 * \defgroup goodies Facilities
 * \file efidir_goodies.h
 * \author Flavien Vernier
 * 
 * \brief Inclusion of efidir facilities
 * 
 * This header file include:
 *  - boolean type,
 *  - efidir alocation functions
 *  - string facilities.
 * 
 * \see efidir_boolean.h efidir_allocation.h
 */


#ifndef EFIDIR_GOODIES_H
#define EFIDIR_GOODIES_H


#include "efidir_boolean.h"
#include "efidir_allocation.h"
#include "efidir_string.h"
#include "efidir_file_txt.h"

#endif /*EFIDIR_GOODIES_H*/
