/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \defgroup common Common tools of EFIDIR
 */


/**
 * \ingroup common
 * \defgroup convert_operators Convert operators
 */


/**
 * \ingroup common
 * \defgroup common_operators Operators
 */


/**
 * \ingroup common
 * \defgroup com_math_tools Common math operators
 */

/**
 * \ingroup common
 * \defgroup atmosphere_operators Atmosphere operators
 */

/**
 * \ingroup common
 * \defgroup filters Filters
 */

/**
 * \ingroup common
 * \defgroup display Display tools
 */

/**
 * \ingroup common
 * \defgroup mosaic Image mosaic
 */

/**
 * \ingroup common
 * \defgroup statistic Statistic on vectors, matrices, images and series
 */

/**
 * \ingroup common
 * \defgroup series Operators to manage series of images
 */

/**
 * \mainpage EFIDIR Tools
 * \section intro_sec Introduction
 * The EFIDIR-Tools is a set of executables and C-functions developed by the members of The EFIDIR project (see: http://www.efidir.fr/).
 * This documentation presents the EFIDIR API split modules by modules and end user informtion in the following sections.
 *
 * Let us note that this documentation is extracted from svn and can contain some mistakes.
 * Moreover, it can present some executables or functionnalities that are not yet available in the public archive of EFIDIR-Tools.
 *
 * \section com_rams_sec Common Programs
 * \subsection classic Classical image operators
 * \li \subpage cal_image
 * \li \subpage crop
 * \li \subpage crop_series
 * \li \subpage difference
 * \li \subpage enlarge
 * \li \subpage flip
 * \li \subpage gain_offset
 * \li \subpage imagescale
 * \li \subpage replace
 * \li \subpage rotate
 * \li \subpage shrink
 * \li \subpage transpose
 * \li \subpage zeropad
 * \subsection cplx Complex operators
 * \li \subpage cal_slc
 * \li \subpage cal_slc_series
 * \subsection convert Conversion operators
 * \li \subpage convert_amplitude_to_jpeg
 * \li \subpage convert_datatype
 * \li \subpage convert_dpl_ori_to_jpeg
 * \li \subpage convert_efidir_to_jpeg
 * \li \subpage convert_roipac_to_efidir
 * \li \subpage convert_contour_to_jpeg
 * \li \subpage convert_floatresult_to_jpeg
 * \li \subpage convert_datatype_series
 * \li \subpage convert_nan_zero
 * \li \subpage convert_amplitude_to_jpeg
 *
 * \li \subpage convert_header_envi_to_roipac
 * \li \subpage convert_header_roipac_to_envi
 * \subsection statistic Statistic
 * \li \subpage fuzzy_stat
 * \li \subpage local_stat
 * \li \subpage temporal_stat
 * \li \subpage series_stat
 * \li \subpage statistics
 * \li \subpage statistics_series
 * \li \subpage histogram
 * \subsection filter Filter
 * \li \subpage filter_lowpass
 * \li \subpage filter_median
 * \li \subpage threshold
 * \subsection coordinate Coordinate
 * \li \subpage latlon2utm
 * \subsection unclassified Unclassified
 * \li \subpage cal_mask
 * \li \subpage coherence_phase
 * \li \subpage eigenvalue
 * \li \subpage extract_band
 * \li \subpage header_tsx
 * \li \subpage mask_visu
 * \li \subpage merge_bands
 * \li \subpage merge_series
 * \li \subpage mosaic
 * \li \subpage mselect_ima
 * \li \subpage simul_image
 * \li \subpage switch_mask
 * \li \subpage weighted_mean
 * \li \subpage width_ori
 * \li \subpage wrap
 * \li \subpage switch_mask
 * \li \subpage centre
 * \li \subpage amplitude_intensity
 * \li \subpage delay
 * \li \subpage coherence_phase_rescaled_filtered
 *
 * \section mdiff_rams_sec Mdiff Programs
 * MDIFF consists of some particular SAR data processing chains.
 * In general, 3 main chains developed in this package correspond to 3 steps of SAR data processing: extraction, fusion and inversion.
 * The MDIFF User Guide can be found <a href="userguide/MdiffUserGuide.pdf">here</a>.
 *
 * \subsection inPhUnwrap Interferometric phase unwrapping chain
 * \li \subpage compare
 * \li \subpage correction_atm
 * \li \subpage filter_multiscale
 * \li \subpage interfero_filter
 * \li \subpage local_fr
 * \li \subpage music
 * \li \subpage phase_to_frequency
 * \li \subpage plot_phi_topo
 * \li \subpage pre_corr_alti2phi
 * \li \subpage prepare_unwrap
 * \li \subpage sar_scale
 * \li \subpage unwrap
 * \li \subpage varphi
 * \subsection postProc Post-processing of image correlation
 * \li \subpage constant_correction
 * \li \subpage correction_ramp
 * \li \subpage correction_topo
 * \li \subpage file_image
 * \li \subpage mod_dir
 * \li \subpage sigma_to_confidence
 * \li \subpage truncation
 * \subsection infoFusion Information fusion
 * \li \subpage binary_image
 * \li \subpage blue
 * \li \subpage fusion
 * \li \subpage fusion_mask
 * \li \subpage fusion_scale
 * \li \subpage pre_fusion
 * \subsection inv3D 3D inversion
 * \li \subpage composite_offset
 * \li \subpage composite_surfdisp
 * \li \subpage fuzzy_intersection
 * \li \subpage fuzzy_inversion
 * \li \subpage fuzzy_projection
 * \li \subpage select_fuzzy_inversion
 * \li \subpage select_surfdisp
 * \li \subpage surfdisp
 * \subsection projVect Manipulation of projection vector
 * \li \subpage dim_trans
 * \li \subpage projection_vector
 * \subsection inv Geophysical deformation model inversion
 * \li \subpage quadtree
 * \li \subpage series_quadtree
 * \subsection mdiffTools Individual tools
 * \li \subpage adapt_smoothing
 * \li \subpage autocorrelation
 * \li \subpage correction_parabola
 * \li \subpage fault_location
 * \li \subpage fault_trace
 * \li \subpage mapinfo
 * \li \subpage mask
 * \li \subpage noise_generator
 * \li \subpage profile
 * \li \subpage regression_2D
 * \li \subpage simple_mosaic
 * \li \subpage variogram
 * 
 *
 * \section lardis_rams_sec Lardis Programs
 * \li \subpage area_dpl_measurement
 * \li \subpage ascii_simul_to_image
 * \li \subpage border_image
 * \li \subpage border_list_image
 * \li \subpage cal_dpl_ori
 * \li \subpage cal_dpl_ori_basic
 * \li \subpage cal_dpl_ori_confidence 
 * \li \subpage cal_log
 * \li \subpage cat_dist_corr_result
 * \li \subpage camera_dpl_list
 * \li \subpage camera_dpl_measurement
 * \li \subpage camera_merge_dpl_list
 * \li \subpage compare_ground_sar
 * \li \subpage crop_image_with_reference_image
 * \li \subpage cumul_ml
 * \li \subpage decim_image
 * \li \subpage delux_median_filter_map
 * \li \subpage dem_camera_visu
 * \li \subpage dist_corr
 * \li \subpage feasible_dpl_measurement_map
 * \li \subpage gen_dist_corr_parameter_files
 * \li \subpage image_orientation
 * \li \subpage image_pair_normalization
 * \li \subpage image_translation
 * \li \subpage inversion_3d_dpl
 * \li \subpage low_pass_filter
 * \li \subpage merge_list_mask
 * \li \subpage ML_tracking_matrix
 * \li \subpage ML_tracking_texture
 * \li \subpage offset_complex
 * \li \subpage overlay_list_image
 * \li \subpage point_dpl_measurement
 * \li \subpage recal_image
 * \li \subpage recal_image2
 * \li \subpage recal_image_apriori
 * \li \subpage regul_markov
 * \li \subpage shift_sar
 * \li \subpage shift_sar_stat
 * \li \subpage simul_camera_image
 * \li \subpage slope_pixel_spacing
 * \li \subpage spatio_temporal_dpl_stat
 * \li \subpage tcheby_poly_approx
 * \li \subpage test_tcheby
 * \li \subpage vector_product
 *
 *
 * \section magnicos_rams_sec Magnicos Programs
 * \li \subpage ps_list
 *
 *
 * \section nsbas_rams_sec Nsbas Programs
 * \li \subpage delayz_erai
 *
 *
 * \section pochem_rams_sec Pochem Programs
 * \li \subpage grid_mask
 * \li \subpage hierarchical_segmentation
 * \li \subpage projection_lexic
 * \li \subpage projection_pauli
 *
 *
 * \section sarlut_rams_sec Sarlut Programs
 * Tools developed by Ivan Petillot during his PhD thesis at LISTIC, Savoie University, for geocoding SAR data and "radar-coding" georeferenced data over airborne or spaceborne SAR images. 
 * These tools start with a DEM of the imaged area and the position or trajectory of the SAR sensor. 
 * They create a visibility mask to take shadow and foldover effects into account and a simulated SAR image to register it on the real SAR image. 
 * The forward and inverse transformations between the two geometries are coded through two pairs of look-up tables (LUT) which provide:
 * \li the Latitude/Longitude coordinates of each pixel in SAR geometry,
 * \li the SAR range/azimuth coordinates of each ground pixel of the DEM.
 * A graphic user interface has been developed by Jean-Michel Vanp (GIPSA-lab, INP Grenoble) to use these LUTs to navigate simultaneously in both geometries.
 * The SARLUT User Guide can be found <a href="userguide/SarlutUserGuide.pdf">here</a>.
 *
 * \li \subpage crop_SAR_image4specific_DEM
 * \li \subpage gen_baseline_perp_DEM_img
 * \li \subpage gen_azimuth_range_imgs_user_precision
 * \li \subpage gen_delta_azimuth_range_master_slave
 * \li \subpage gen_diff_dist_img
 * \li \subpage gen_diff_time_img
 * \li \subpage gen_dist_time_img
 * \li \subpage gen_lat_long_imgs
 * \li \subpage gen_LUTs_on_master_grid
 * \li \subpage gen_SAR_coord_DEM_img
 * \li \subpage geo_crop_from_1_point_series
 * \li \subpage get_diff_master_SAR_resampled_SAR
 * \li \subpage get_SAR_coord_1_point
 * \li \subpage get_master_SAR_from_series
 * \li \subpage get_baseline_perp_1_point
 * \li \subpage ground_2_SAR_transform
 * \li \subpage intensity_ground
 * \li \subpage intensity_slant
 * \li \subpage interpol_lut_ground2radar
 * \li \subpage interpol_lut_ground2radar_u1
 * \li \subpage interpol_lut_points_ground2radar
 * \li \subpage interpol_lut_radar2ground
 * \li \subpage interpol_lut_radar2ground_u1
 * \li \subpage interpol_lut_points_ground2radar
 * \li \subpage interpol_lut_ground2radar_multiband
 * \li \subpage interpol_azim_range_radar2ground
 * \li \subpage lut
 * \li \subpage mask_ground
 * \li \subpage mask_slant
 * \li \subpage recal_correl
 * \li \subpage transform_lut_utm
 * \li \subpage transform_RST
 * \li \subpage tsx_gamma_output_file_2_rsc
 *
 *
 * \section spatpam_rams_sec Spatpam Programs
 * The SPATPAM User Guide can be found <a href="userguide/SpatpamUserGuide.pdf">here</a>.
 *
 * \li \subpage pattern_localization
 * \li \subpage SITS_H_Alpha_quantization
 * \li \subpage SITS_quantization
 * \li \subpage SITS_user_defined_quantization
 *
 * \section workflows Workflows
 * Workflows, also called "Chains", are operations composed of multiple
 * operators.

 * \li \subpage sar_amplitude_2d_displacement_ground
 *
 * \section install_sec Installation
 * \subsection step1_sec Step 1:
 *   `cd' to the directory containing the package's source code and type
 *   `./configure' to configure the package for your system.
 *   Running `configure' might take a while.  While running, it prints
 *   some messages telling which features it is checking for.
 *
 * \subsection step2_sec Step 2:
 *   Type `make' to compile the package.
 *
 * \subsection step3_sec Step 3:
 *   Optionally, type `make check' to run any self-tests that come with
 *   the package.
 *
 * \subsection step4_sec Step 4:
 *   Type `make install' to install the programs, data files and
 *   documentations.
 *
 * \subsection step5_sec Step 5:
 *   You can remove the program binaries and object files from the
 *   source code directory by typing `make clean'.  To remove the
 *   files that `configure' created as well(so you can compile the package on
 *   a different kind of compilator), type `make distclean'.  There is
 *   also a `make maintainer-clean' target, but that is intended mainly
 *   for the package's developers.  If you use it, you may have to get
 *   all sorts of other programs in order to regenerate files that came
 *   with the distribution.
 *
 * \subsection step6_sec Step 6:
 *   Of course, you can also type `make uninstall' to remove the installed
 *   files.
 *
 */

#ifndef COMMON_H
#define COMMON_H
#include "com_allocation.h"
#include "com_boolean.h"
#include "com_gain_offset.h"
#include "efidir_image.h"
#include "efidir_param.h"
#include "com_string.h"
#include "com_assert.h"
#include "com_extract_band.h"
#include "com_goodies.h"
#include "com_raster.h"
#include "com_math.h"
#include "com_complex.h"
#endif
