/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup filters
* \defgroup weighted_mean Weighted mean filter with a reduction of scale
*/

/**
* \ingroup weighted_mean
* \file com_weighted_mean.h
* \author Yajing Yan
*
* \brief operator of lowpass filter with a reduction of scale
*
*file includs the structures, the prototypes of functions of the operator weighted_mean
*
*/

#ifndef COM_WEIGHTED_MEAN_H
#define COM_WEIGHTED_MEAN_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"

/**
* \ingroup weighted_mean
* \typedef typedef Weighted_mean_param
*
* \brief structure that contains the parameters of the operator
*
*/
typedef struct struct_weighted_mean_param
{
  int r;/*number of rows of the filter window*/
  int c;/*number of columns of the filter window*/
}weighted_mean_param, *Weighted_mean_param;

/**
 * \ingroup weighted_mean
 * \fn Weighted_mean_param new_weighted_mean_param();
 *
 * \return A new reference on allocated weighted_mean_param structure
 *
 * \brief Create a new Weighted_mean_param reference
 *
 */

static Weighted_mean_param new_weighted_mean_param();

/**
 * \ingroup weighted_mean
 * \fn void free_weighted_mean_param(Weighted_mean_param p);
 *
 * \param p A reference on a weighted_mean_param structure
 *
 * \brief Free an allocated Weighted_mean_param reference
 *
 */

void free_weighted_mean_param(Weighted_mean_param p);

/**
* \ingroup weighted_mean
* \fn void define_weighted_mean_param(char *extra_description);
* \brief Default efidir function that defines parameters
*
* \param extra_description Extra description for multi definition of the same parameter(NULL is accepted)
*
*/
void define_weighted_mean_param(char *extra_description);

/**
* \ingroup weighted_mean
* \fn Weighted_mean_param get_weighted_mean_param();
* \brief Default efidir function that gets parameters
*
* \return a Weighted_mean_param that contains the parameters
*/
Weighted_mean_param get_weighted_mean_param();

/**
* \ingroup weighted_mean
* \fn void weighted_mean(Weighted_mean_param p,EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask,EFIDIRImage outputConf,EFIDIRImage outputConfMask);
* \brief weighted mean filter
*
* \param p is the structure parameter for the operator
* \param inputImage is the image before the filtering 
* \param inputMask is the mask of the image before the filtering
* \param inputConf is the confidence image of the image before the filtering
* \param inputConfMask is the mask of the confidence image before the filtering
* \param outputImage is the image after the filtering
* \param outputMask is the mask of the image after the filtering
* \param outputConf is the confidence image of the image after the filtering
* \param outputConfMask is the mask of the confidence image after the filtering
*
*/
void weighted_mean(Weighted_mean_param p,EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask,EFIDIRImage outputConf,EFIDIRImage outputConfMask);

#endif/*COM_WEIGHTED_MEAN_H*/
