/*
 *  Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *  This file is part of EFIDIR tools.
 *
 *  EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  EFIDIR tool(s) is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public licence
 *  along with EFIDIR tools. If not, see <http://www.gnu.org/licenses/>.
 */


#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "efidir_allocation.h"
#include "com_warp_image.h"
#include "com_warp_matrix.h"


//Coef_matrix load_coef_file(char * filePath);
/**
 * \ingroup mosaic
 * \defgroup warp_parse_registraction_file Registraction of images to get a new image from several images with common areas
 */

/**
 * \ingroup mosaic
 * \author Vincent Laugier and Jean-Denis Coffre
 * \brief Several functions to get a new image from several images with common areas
*/


#ifndef __WARP_PARSE_REGISTRATION_FILE_H__
#define __WARP_PARSE_REGISTRATION_FILE_H__

/**
 * \ingroup mosaic
 * \fn Warp_Matrix * matrix_from_points(double * x, double * y, double * x_p, double * y_p, int n, int degree);
 * \brief Function of determination of coefficients of polynome of transformation 
 *
 * \param x is the coordinate x of points
 * \param y is the coordinate y of points
 * \param x_p is the coefficient for x of polynome 
 * \param y_p is the coefficient for y of polynome
 * \param n is the number of points
 * \param degree is the degree of transformation
 * 
 */

Warp_Matrix * matrix_from_points(double * x, double * y, double * x_p, double * y_p, int n, int degree);


/**
 * \ingroup mosaic
 * \fn Coef_matrix * get_coef_matrix (char * points_file_path, int nb_point,int degree);
 * \brief Create two new coef_matrix from points listed in a file. First one contains the coefficients of the transformation from base to warp, and the second from warp to base.
 * 
 * File structure : 
 * The function will ignore each line which begins with a ";"
 * Each line must respect the following pattern : 
 * x y x' y'
 * where x and y are the coordinates of points in the base image, and x' and y' are the coresponding coordinates in the warp image
 * \param points_file_path - the path of the file to load
 * \param nb_point - number of points to load in the file. The function will process even if it reaches the end of file before loading as many points as specified in nb_point, but will plante if there is not enough points : number of points must be at least equals to (degree+1)². Example : you need at least 4 lines in the file and nb_points must equals at least 4, otherwise the function will stop and raise an error.
 * \param degree - the degree of the polynoms corresponding to the transformations
 
*/
Coef_matrix * get_coef_matrix (char * points_file_path, int nb_point,int degree);

#endif
