/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup com_resize_image
 * \defgroup transpose Transpose an image  A tester extensivement....
 */

/**
 * \ingroup transpose
 * \file com_transpose.h
 * \author Erwan Pathier Si si !!!
 * 
 * \brief operator of transpose
 * 
 * file includes (stucture, prototype de fonction) of the operator transpose
 * 
 * 
 */

#ifndef COM_TRANSPOSE_H
#define COM_TRANSPOSE_H

#include <stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup transpose
 * \fn void transpose(EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief function of transpose
 * Function allowing to transpose an image
 *
 * \param inputImage is the image to transpose
 * \param outputImage is the result of transposed image
 *
 */
void transpose(EFIDIRImage inputImage, EFIDIRImage outputImage);


#endif
