/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup common_operators
* \defgroup threshold Thresholding 
*/

/**
* \ingroup threshold
* \file com_threshold.h
* \author Yajing Yan
*
* \brief operator of threshold
*
*file includs the structures,the prototypes of functions of the operator threshold
*
*/

#ifndef COM_THRESHOLD_H
#define COM_THRESHOLD_H

#include<stdio.h>
#include<stdlib.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"

/**
* \ingroup threshold
* \typedef typedef Threshold_param
*
* \brief structure that contains the parameters of the operator
*
*/
typedef struct struct_threshold_param{
  double max; /*maximum limite*/
  double min; /*mininum limite*/
  int cplx_value; /* thresholding value for complex*/
}threshold_param,*Threshold_param;


/**
 * \ingroup threshold
 * \fn Threshold_param new_threshold_param();
 *
 * \return A new reference on allocated threshold_param structure
 *
 * \brief Create a new Threshold_param reference
 *
 */

static Threshold_param new_threshold_param();

/**
 * \ingroup threshold
 * \fn void free_threshold_param(Threshold_param p);
 *
 * \param p A reference on a threshold_param structure
 *
 * \brief Free an allocated Threshold_param reference
 *
 */
void free_threshold_param(Threshold_param p);

/**
* \ingroup threshold
* \fn void define_threshold_param(char *extra_description);
* \brief Default efidir function that defines parameters
*
* \param extra_description Extra description for multi definition of the same parameter(NULL is accepted)
*/
void define_threshold_param(char *extra_description);

/**
* \ingroup threshold
* \fn Threshold_param get_threshold_param();
* \brief Default efidir function that gets parameters
*
* \return A Threshold_param that contains the parameters
*/
Threshold_param get_threshold_param();

/**
* \ingroup threshold
* \fn void threshold(Threshold_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage, EFIDIRImage outputMask);
* \brief function of threshold 
*function making a threshold of the value in the image.
*
* \param p is the structure parameter for the operator 
* \param inputImage is the image before the threshold
* \param inputMask is the mask of the inputImage
* \param outputImage is the image after the threshold
* \param outputMask is the mask of the outputImage
*
*/
void threshold(Threshold_param p,EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage, EFIDIRImage outputMask);

#endif /*COM_THRESHOLD_H*/
