/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_SWITCH_MASK_H
#define COM_SWITCH_MASK_H

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include <stdlib.h> 

/**
 * \ingroup common_operators
 * \defgroup switch_mask Switch the mask value
 */
/**
 * \ingroup switch_mask
 * \typedef Switch_mask_param
 * \author Yajing Yan
 *
 * \brief reference on switch_mask_param structure
 *
 */

/**
 * \ingroup switch_mask
 * \struct switch_mask_param
 *
 * \brief structure that contains the parameters of the operator switch_mask
 *
 */
typedef struct struct_switch_mask_param{
  int index; /*!< processing index */
}switch_mask_param, *Switch_mask_param;

/**
 * \ingroup switch_mask
 * \fn new_switch_mask_param()
 *
 * \return A new reference on allocated switch_mask_param structure
 *
 * \brief Create a new Switch_mask_param reference 
 *
 */
static Switch_mask_param new_switch_mask_param();
/**
 * \ingroup switch_mask
 * \fn free_switch_mask_param(Switch_mask_param p)
 *
 * \param p A reference on a switch_mask_param structure
 *
 * \brief Free an allocated Switch_mask_param reference 
 *
 */
void free_switch_mask_param(Switch_mask_param p);

/**
 * \ingroup switch_mask
 * \fn void define_switch_mask_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_switch_mask_param(char *extra_description);
/**
 * \ingroup switch_mask
 * \fn Switch_mask_param get_switch_mask_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Switch_mask_param that contains the parameters.
 */
Switch_mask_param get_switch_mask_param();

/**
 * \ingroup switch_mask
 * \fn void switch_mask(Switch_mask_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief Switch the mask value
 * function allowing to switch the mask value, as the convention of mask is not uniform in EFIDIR Tools
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the input mask
 * \param outputImage is the output mask
 *
 */
void switch_mask(Switch_mask_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);

#endif
