/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup common_operators
 * \defgroup simul_image Simulate surface 3d to create test image (polynomial, multidimensional gaussian...)
 */
/**
 * \ingroup simul_image
 * \file com_simul_image.h
 * \author Renaud Fallourd
 * 
 * \brief operator of generation of simul_image
 * 
 * file includes (stucture, prototype de fonction) of the operator simul_image
 * 
 * 
 */

#ifndef COM_SIMUL_SURF3D_H
#define COM_SIMUL_SURF3D_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup simul_image
 * \typedef Simul_image_param
 *
 * \brief reference on simul_image_param structure
 *
 */
/**
 * \ingroup simul_image
 * \struct simul_image_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_simul_image_param{
  int nb_lig; /*!< number of lines of simulted image */
  int nb_col; /*!< number of colones of simulted image */
  float x0_pos;  /*!< position of x=0 in simulated image */
  float y0_pos;  /*!< position of y=0 in simulated image */
  float step;  /*!< step for x and y values */
  int fc_choice; /*!< function choice */
}simul_image_param, *Simul_image_param;


/**
 * \ingroup simul_image
 * \fn Simul_image_param new_simul_image_param()
 *
 * \return A new reference on allocated simul_image_param structure
 *
 * \brief Create a new Simul_image_param reference 
 *
 */
static Simul_image_param new_simul_image_param();
/**
 * \ingroup simul_image
 * \fn void free_simul_image_param(Simul_image_param p)
 *
 * \param p A reference on a simul_image_param structure
 *
 * \brief Free an allocated Simul_image_param reference 
 *
 */
void free_simul_image_param(Simul_image_param p);


/**
 * \ingroup simul_image
 * \fn void define_simul_image_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_simul_image_param(char *extra_description);

/**
 * \ingroup simul_image
 * \fn Simul_image_param get_simul_image_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simul_image_param that contains the parameters.
 */
Simul_image_param get_simul_image_param();

/**
 * \ingroup simul_image
 * \fn void simul_image(Simul_image_param p, EFIDIRImage outputImage);
 * \brief function of calculate simulated image
 * Function allowing to computed simulation image acccording to user's 3d function choice
 *
 * \param p is the structure of the parameters for the operator 
 * \param outputImage is the simulated image
 *
 */
 void simul_image(Simul_image_param p, EFIDIRImage outputImage);

#endif
