/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_SHRINK_H
#define COM_SHRINK_H

#include "efidir_image.h"
#include "efidir_image_info.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include <stdlib.h> 

/**
 * \ingroup com_resize_image
 * \defgroup shrink Image zero padding.
 */
/**
 * \ingroup shrink
 * \typedef Shrink_param
 * \author Matthieu Volat (ISTerre)
 *
 * \brief reference on shrink_param structure
 */

/**
 * \ingroup shrink
 * \struct shrink_param
 *
 * \brief structure that contains the parameters of the operator shrink
 */
typedef struct struct_shrink_param{
  int factor;	/*!< Shrink factor */
  int xOffset; /*!< columns to skip */
  int yOffset; /*!< lines to skip */
} shrink_param, *Shrink_param;

/**
 * \ingroup shrink
 * \fn new_shrink_param()
 *
 * \return A new reference on allocated shrink_param structure
 *
 * \brief Create a new Shrink_param reference 
 */
Shrink_param new_shrink_param();

/**
 * \ingroup shrink
 * \fn free_shrink_param(Shrink_param p)
 *
 * \param p reference on a shrink_param structure
 *
 * \brief Free an allocated Shrink_param reference 
 */
void free_shrink_param(Shrink_param p);

/**
 * \ingroup shrink
 * \fn void define_shrink_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 *        the same parameter (NULL is accepted)
*/
void define_shrink_param(char *extra_desc);

/**
 * \ingroup shrink
 * \fn Shrink_param get_shrink_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Shrink_param that contains the parameters.
 */
Shrink_param get_shrink_param();

/**
 * \ingroup shrink
 * \fn void shrink(Shrink_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief Shrink an image
 *
 * The shrink operator srink an image.
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage Image to be shrinkped. Image data can be not loaded.
 * \param outputImage is the image of result
 *
 */
void shrink(Shrink_param p, EFIDIRImage in, EFIDIRImage out);

#endif /* SHRINK_H */
