/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup display
 * \defgroup scale Scale an input image
 */
/**
 * \ingroup scale
 * \file com_scale.h
 * \author Flavien Vernier (LISTIC)
 * 
 * \brief operator of generation of scale image
 * 
 * file includes (stucture, prototype de fonction) of the operator scale
 * 
 * 
 */

#ifndef COM_SCALE_H
#define COM_SCALE_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#if __OPENCV__
# include "efidir_opencv.h"
#endif /* __OPENCV__ */


/**
 * \ingroup scale
 * \typedef Scale_param
 *
 * \brief reference on scale_param structure
 *
 */
/**
 * \ingroup scale
 * \struct scale_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_scale_param{
  int row_fact ; /*!< line scale factor */
  int column_fact; /*!< column scale factor*/
  int interpolation; /*!< interpolation method (only CV_INTER_LINEAR)*/ 
}scale_param, *Scale_param;

/**
 * \ingroup scale
 * \fn new_scale_param()
 *
 * \return A new reference on allocated scale_param structure
 *
 * \brief Create a new Scale_param reference 
 *
 */
static Scale_param new_scale_param();

/**
 * \ingroup scale
 * \fn free_scale_param(Scale_param p)
 *
 * \param p A reference on a scale_param structure
 *
 * \brief Free an allocated Scale_param reference 
 *
 */
void free_scale_param(Scale_param p);



/**
 * \ingroup scale
 * \fn void define_scale_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_scale_param(char *extra_description);

/**
 * \ingroup scale
 * \fn Scale_param get_scale_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Scale_param that contains the parameters.
 */
Scale_param get_scale_param();



/**
 * \ingroup scale
 * \fn void scale(Scale_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief function of generation of a scale image
 *
 * \param p parameters of scale
 * \param inputImage is the input image
 * \param outputImage is the output image, cannot be NULL, but data must be NULL, if not NULL it will be freed and reallocated according to input image and factors.
 *
 */
void scale(Scale_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);

#endif
