/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_REPLACE_H
#define COM_REPLACE_H

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include <stdlib.h> 
#include <math.h>

/**
 * \ingroup common_operators
 * \defgroup replace Replace image value
 */
/**
 * \ingroup replace
 * \typedef Replace_param
 * \author Yajing Yan
 *
 * \brief reference on replace_param structure
 *
 */

/**
 * \ingroup replace
 * \struct replace_param
 *
 * \brief structure that contains the parameters of the operator replace
 *
 */
typedef struct struct_replace_param{
  double input; /*!< value to be replaced */
  double output; /*!< value to replace */
}replace_param, *Replace_param;

/**
 * \ingroup replace
 * \fn new_replace_param()
 *
 * \return A new reference on allocated replace_param structure
 *
 * \brief Create a new Replace_param reference 
 *
 */
static Replace_param new_replace_param();
/**
 * \ingroup replace
 * \fn free_replace_param(Replace_param p)
 *
 * \param p A reference on a replace_param structure
 *
 * \brief Free an allocated Replace_param reference 
 *
 */
void free_replace_param(Replace_param p);

/**
 * \ingroup replace
 * \fn void define_replace_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_replace_param(char *extra_description);
/**
 * \ingroup replace
 * \fn Replace_param get_replace_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Replace_param that contains the parameters.
 */
Replace_param get_replace_param();

/**
 * \ingroup replace
 * \fn void replace(Replace_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief Replace image value
 * function allowing to replace image value according to the need of uses
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the input image
 * \param outputImage is the output image
 *
 */
void replace(Replace_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);

#endif
