/*  Copyright (c) 2008. The EFIDIR team. All right reserved.
* 
*  This file is part of EFIDIR tools.
* 
*  EFIDIR tool(s) is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
*  EFIDIR tool(s) is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
* t
*  You should have received a copy of the GNU General Public License
* along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
* 
*  Any information about the EFIDIR project can be found on www.efidir.fr
*/


#ifndef COM_MERGE_SERIES_H
#define COM_MERGE_SERIES_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_math.h"
#include "efidir_image_list.h"
#include "efidir_param.h"


/**
 *  \ingroup series
 * \defgroup merge_series Merge an image series into an image according to X/Y start
 */
/**
 * \ingroup merge_series
 * \author Flavien Vernier (Univ. Savoie)
 *
 */
/**
 * \ingroup merge_series
 * \struct merge_series_param
 *
 * \brief structure that contains the parameters of the operator merge_series
 *
 */
typedef struct merge_series_param
{
  int minStartX, minStartY;
}merge_series_param, *Merge_series_param;

/**
 * \ingroup merge_series
 * \fn new_merge_series_param()
 *
 * \return A new reference on allocated merge_series_param structure
 *
 * \brief Create a new merge_series_param reference 
 *
 */
Merge_series_param new_merge_series_param();

/**
 * \ingroup merge_series
 * \fn void free_merge_series_param(merge_series_param p)
 *
 * \param p A reference on a merge_series_param structure
 *
 * \brief Free an allocated merge_series_param reference 
 *
 */
void free_merge_series_param(Merge_series_param p);

/**
 * \ingroup merge_series
 * \fn void define_merge_series_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_merge_series_param(char *extra_description);

/**
 * \ingroup merge_series
 * \fn merge_series_param get_merge_series_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A merge_series_param that contains the parameters.
 */
Merge_series_param get_merge_series_param();

/**
 * \ingroup merge_series
 * \fn void merge_series(Merge_series_param p, EFIDIRListImage inputImages, EFIDIRImage outputImage);
 * \brief Merge_Series a list of images
 * 
 * Merge_Series a list of images according XY starts into a unique image
 *
 * \warning Each data of image of the list will be (re-)loaded and freed
 *
 * \param p is the structure of the parameters for operators
 * \param inputImages is a list of image to be used
 * \param outputImage is the image of result
 *
 */
void merge_series(Merge_series_param p, EFIDIRListImage inputImages, EFIDIRImage outputImage); 


#endif
