/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup common_operators
 * \defgroup merge_bands merges the bands of an image according to a merge function
 */
/**
 * \ingroup merge_bands
 * \file com_merge_bands.h
 * \author Flavien Vernier (LISTIC)
 * 
 * \brief operator to merge the bands of an image according to a merge function
 * 
 * file includes (stucture, prototype de fonction) of the operator merge_bands
 * 
 * 
 */

#ifndef COM_MERGE_BANDS_H
#define COM_MERGE_BANDS_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup merge_bands
 * \typedef Merge_bands_param
 *
 * \brief reference on merge_bands_param structure
 *
 */
/**
 * \ingroup merge_bands
 * \struct merge_bands_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_merge_bands_param{
  int type; /*!< intern parameter */
}merge_bands_param, *Merge_bands_param;

/**
 * \ingroup merge_bands
 * \fn Merge_bands_param new_merge_bands_param()
 *
 * \return A new reference on allocated merge_bands_param structure
 *
 * \brief Create a new Merge_bands_param reference 
 *
 */
static Merge_bands_param new_merge_bands_param();
/**
 * \ingroup merge_bands
 * \fn void free_merge_bands_param(Merge_bands_param p)
 *
 * \param p A reference on a merge_bands_param structure
 *
 * \brief Free an allocated Merge_bands_param reference 
 *
 */
void free_merge_bands_param(Merge_bands_param p);


/**
 * \ingroup merge_bands
 * \fn void define_merge_bands_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_merge_bands_param(char *extra_description);

/**
 * \ingroup merge_bands
 * \fn Merge_bands_param get_merge_bands_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Merge_bands_param that contains the parameters.
 */
Merge_bands_param get_merge_bands_param();


/**
 * \ingroup merge_bands
 * \fn void merge_bands(Merge_bands_param p, EFIDIRImage inputImage, EFIDIRImage mergedImage);
 * \brief function to merge the bands of an image according to a merge function
 *
 * Function allowing to merge bands of an image.
 * The merge fonction can be magnitude or power.
 *
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the input image
 * \param mergedImage is the merged image
 *
 */
void merge_bands(Merge_bands_param p, EFIDIRImage inputImage, EFIDIRImage mergedImage);
#endif
