/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup display
 * \defgroup mask_visu Visualize the masked value in an image
 */
/**
 * \ingroup mask_visu
 * \file com_mask_visu.h
 * \author Yajing Yan (LISTIC)
 * 
 * \brief operator of visualisation of masked value in an image
 * 
 * file includes (stucture, prototype de fonction) of the operator mask_visu
 * 
 * 
 */

#ifndef COM_MASK_VISU_H
#define COM_MASK_VISU_H

#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "efidir_image.h"
#include "efidir_param.h"


/**
 * \ingroup mask_visu
 * \fn EFIDIRImage float2bit(EFIDIRImage inputImage);
 * \brief function of transformation of float image to byte image (0-255)
 * Function allowing to transform float image to 8 bits image (0-255)
 *
 * \param inputImage is the float image
 * \return a 8 bits image
 *
 */

EFIDIRImage float2bit(EFIDIRImage inputImage);

/**
 * \ingroup mask_visu
 * \fn void mask_visu(EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage);
 * \brief function of visualisation of masked value in an image
 * Function allowing to visualize the masked value in an image
 *
 * \param inputImage is the image to be classified
 * \param inputMask is the mask image
 * \param outputImage is the classified image
 *
 */
void mask_visu(EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage);


#endif
