/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup common_operators
 * \defgroup histogram Calculate the histogram
 */
/**
 * \ingroup histogram
 * \file com_histogram.h
 * \author Yajing Yan (LISTIC)
 * 
 * \brief operator of calculating an histogram
 * 
 * file includes (stucture, prototype de fonction) of the operator histogram
 * 
 * 
 */

#ifndef COM_HISTOGRAM_H
#define COM_HISTOGRAM_H

#include <stdlib.h>
#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup histogram
 * \typedef Histogram_param
 *
 * \brief reference on histogram_param structure
 *
 */
/**
 * \ingroup histogram
 * \struct histogram_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_histogram_param{
  int nb; /*!< number of range */
  float  max_value; /*!< maximum value of data */
  float  min_value;  /*!< minimum value of data */
}histogram_param, *Histogram_param;

/**
 * \ingroup histogram
 * \fn new_histogram_param()
 *
 * \return A new reference on allocated histogram_param structure
 *
 * \brief Create a new Histogram_param reference 
 *
 */
static Histogram_param new_histogram_param();
/**
 * \ingroup histogram
 * \fn free_histogram_param(Histogram_param p)
 *
 * \param p A reference on a histogram_param structure
 *
 * \brief Free an allocated Histogram_param reference 
 *
 */
 void free_histogram_param(Histogram_param p);


/**
 * \ingroup histogram
 * \fn void define_histogram_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_histogram_param(char *extra_description);

/**
 * \ingroup histogram
 * \fn Histogram_param get_histogram_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Histogram_param that contains the parameters.
 */
Histogram_param get_histogram_param();

/**
 * \ingroup histogram
 * \fn void histogram(Histogram_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, char *filename);
 * \brief function of histogram drawing
 * Function allowing to draw an histogram 
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the image of parameter
 * \param inputMask is the mask of the parameter image
 * \param filename is the file containing the data for the histogram
 *
 */
void histogram(Histogram_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, char *filename);


#endif
