/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef HEADER_TSX_H
#define HEADER_TSX_H

#include <stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_assert.h"

/**
 * \ingroup common_operators
 * \defgroup header_tsx For a TSX .cos image create a .hdr file 
 */
/**
 * \ingroup tsx
 * \typedef typedef Header_tsx_param
 *
 * \brief reference on header_tsx_param structure
 *
 */
/**
 * \ingroup tsx
 * \struct header_tsx_param
 *
 * \brief structure that contains the parameters of the operator header_TSX
 *
 */
typedef struct struct_header_tsx_param{
  int bib; /*!< Bytes In Burst (The number of bytes in the actual burst) */
  int rsri; /*!< Range Sample Relative Index */
  int rs; /*!< Range Samples */
  int as; /*!< Azimuth Samples */
  int bi; /*!<  Burst Index (The index number of the burst) */
  int rtnb; /*!< Rangeline Total Number of Bytes */
  int tnl; /*!< Total Number of Lines (including the annotation lines) */
  int nb_r; /*!< number of lines */
  int nb_c; /*!< number of columns */
  int offset; /*!< Header Offset (in bytes) */
}header_tsx_param, *Header_tsx_param;

/**
 * \ingroup tsx
 * \fn Header_tsx_param new_header_tsx_param();
 *
 * \return A new reference on allocated header_tsx_param structure
 *
 * \brief Create a new Header_tsx_param reference
 *
 */
Header_tsx_param new_header_tsx_param();

/**
 * \ingroup tsx
 * \fn void free_header_tsx_param(Header_tsx_param p);
 *
 * \param p A reference on a header_tsx_param structure
 *
 * \brief Free an allocated Header_tsx_param reference
 *
 */

void free_header_tsx_param(Header_tsx_param p);

/**
 * \ingroup tsx
 * \fn void define_header_tsx_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of
 * the same parameter (NULL is accepted) 
*/
void define_header_tsx_param(char *extra_description);
  

/**
 * \ingroup tsx
 * \fn void header_tsx(Header_tsx_param p, char *input_file_name);
 * \brief fonction qui va lire l'entete d'une image TerraSAR-X .cos et crée un .hdr
 *
 * \param p est la structure des paramètres piochés dans l'entete
 * \param input_file_name is the TerraSAR-X file name
*/
void header_tsx(Header_tsx_param p, char *input_file_name);


/**
 * \ingroup tsx
 * \fn void write_tsx_hdr(Header_tsx_param p, char *name);
 * \brief function that write the.hdr file of TerraSAR-X image
 *
 * \param p est la structure des paramètres piochés dans l'entete
 * \param name is the .hdr file name
*/
void write_tsx_hdr(Header_tsx_param p, char *output_file_name);

#endif /*HEADER_TSX_H*/
