/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup com_resize_image
 * \defgroup flip Flip an image (left/right or top/bottom)
 */
/**
 * \ingroup flip
 * \file com_flip.h
 * \author Yajing Yan
 * 
 * \brief operator of flip
 * 
 * file includes (stucture, prototype de fonction) of the operator flip
 * 
 * 
 */

#ifndef COM_FLIP_H
#define COM_FLIP_H

#include <stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup flip
 * \enum flipAxes constant definition of flip axes
 * \brief flip type
 */
enum flipAxes{
  LEFTRIGHT = 1, /*!< flip from left to right*/
  TOPBOTTOM = 2  /*!< flip from top to bottom*/
};

/**
 * \ingroup flip
 * \fn void flip(EFIDIRImage inputImage, int index, EFIDIRImage outputImage);
 * \brief function of flip
 * Function allowing to flip an image
 *
 * \param inputImage is the image to flip
 * \param index is the processing index, possible values are: LEFTRIGHT or TOPBOTTOM
 * \param outputImage is the result of flipped image
 *
 */
void flip(EFIDIRImage inputImage, int index, EFIDIRImage outputImage);


#endif
