/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup filters
* \defgroup filter_median Median filter 
*/

/**
* \ingroup filter_median
* \file com_filter_median.h
* \author yajing yan
*
* \brief operator of median filter
* file includs structures, prototypes of function of the operator filter_median
*
*/

#ifndef COM_FILTER_MEDIAN_H
#define COM_FILTER_MEDIAN_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"

/**
* \ingroup filter_median
* \typedef typedef Filter_median_param
*
* \brief structure that contains the parameters of the operator
*
*/
typedef struct struct_filter_median_param
{
  int r;/*number of rows of the filter window*/
  int c;/*number of columns of the filter window*/
}filter_median_param, *Filter_median_param;

/**
 * \ingroup filter_median
 * \fn Filter_median_param new_filter_median_param();
 *
 * \return A new reference on allocated filter_median_param structure
 *
 * \brief Create a new Filter_median_param reference
 *
 */

static  Filter_median_param new_filter_median_param();

/**
 * \ingroup filter_median
 * \fn void free_filter_median_param(Filter_median_param p);
 *
 * \param p A reference on a filter_median_param structure
 *
 * \brief Free an allocated Filter_median_param reference
 *
 */

void free_filter_median_param(Filter_median_param p);

/**
* \ingroup filter_median
* \fn void define_filter_median_param(char *extra_description);
* \brief Default efidir function that defines parameters
*
* \param extra_description Extra description for multi definition of the same parameter(NULL is accepted)
*
*/
void define_filter_median_param(char *extra_description);

/**
* \ingroup filter_median
* \fn Filter_median_param get_filter_median_param();
* \brief Default efidir function that gets parameters
*
* \return a Filter_median_param that contains the parameters
*/
Filter_median_param get_filter_median_param();

/**
* \ingroup filter_median
* \fn float median(float *tab, int dim);
* \brief function of sorting a float number table
*
* \param *tab is the float number table
* \param dim is the dimension of the float number table
*
*/
float median(float *tab, int dim);

/**
* \ingroup filter_median
* \fn void filter_median(Filter_median_param p,EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask,EFIDIRImage outputConf,EFIDIRImage outputConfMask);
* \brief median filter
*
* \param p is the structure parameter for the operator
* \param inputImage is the image before the filtering 
* \param inputMask is the mask of the image before the filtering
* \param inputConf is the confidence image of the image before the filtering
* \param inputConfMask is the mask of the confidence image before the filtering
* \param outputImage is the image after the filtering
* \param outputMask is the mask of the image after the filtering
* \param outputConf is the confidence image of the image after the filtering
* \param outputConfMask is the mask of the confidence image after the filtering
*
*/
void filter_median(Filter_median_param p,EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask,EFIDIRImage outputConf,EFIDIRImage outputConfMask);

#endif/*COM_FILTER_MEDIAN_H*/
