/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup filters
* \defgroup filter_lowpass Mean weighted filter with the same scale
*/

/**
* \ingroup filter_lowpass
* \file com_filter_lowpass.h
* \author Yajing Yan
*
* \brief operator of lowpass filter
*
*file includs structures, prototypes of function of the operator filter_lowpass
*
*/

#ifndef COM_FILTER_LOWPASS_H
#define COM_FILTER_LOWPASS_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include"efidir_image.h"
#include"efidir_param.h"

/**
* \ingroup filter_lowpass
* \typedef typedef Filter_lowpass_param
*
* \brief structure that contains the parameters of the operator
*
*/
typedef struct struct_filter_lowpass_param
{
  int r; /*!<*number of rows of the filter window */
  int c; /*!<number of columns of the filter window */
}filter_lowpass_param, *Filter_lowpass_param;

/**
 * \ingroup filter_lowpass
 * \fn Filter_lowpass_param new_filter_lowpass_param();
 *
 * \return A new reference on allocated filter_lowpass_param structure
 *
 * \brief Create a new Filter_lowpass_param reference
 *
 */

static  Filter_lowpass_param new_filter_lowpass_param();

/**
 * \ingroup filter_lowpass
 * \fn void free_filter_lowpass_param(Filter_lowpass_param p);
 *
 * \param p A reference on a filter_lowpass_param structure
 *
 * \brief Free an allocated Filter_lowpass_param reference
 *
 */

void free_filter_lowpass_param(Filter_lowpass_param p);

/**
* \ingroup filter_lowpass
* \fn void define_filter_lowpass_param(char *extra_description);
* \brief Default efidir function that defines parameters
*
* \param extra_description Extra description for multi definition of the same parameter(NULL is accepted)
*
*/
void define_filter_lowpass_param(char *extra_description);

/**
* \ingroup filter_lowpass
* \fn Filter_lowpass_param get_filter_lowpass_param();
* \brief Default efidir function that gets parameters
*
* \return a Filter_lowpass_param that contains the parameters
*/
Filter_lowpass_param get_filter_lowpass_param();

/**
* \ingroup filter_lowpass
* \fn void filter_lowpass(Filter_lowpass_param p,EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask,EFIDIRImage outputConf,EFIDIRImage outputConfMask);
* \brief lowpass filter
*
* \param p is the structure parameter for the operator
* \param inputImage is the image before the filtering 
* \param inputMask is the mask of the image before the filtering
* \param inputConf is the confidence image of the image before the filtering
* \param inputConfMask is the mask of the confidence image before the filtering
* \param outputImage is the image after the filtering
* \param outputMask is the mask of the image after the filtering
* \param outputConf is the confidence image of the image after the filtering
* \param outputConfMask is the mask of the confidence image after the filtering
*
*/
void filter_lowpass(Filter_lowpass_param p,EFIDIRImage inputImage,EFIDIRImage inputMask,EFIDIRImage inputConf,EFIDIRImage inputConfMask,EFIDIRImage outputImage,EFIDIRImage outputMask,EFIDIRImage outputConf,EFIDIRImage outputConfMask);

#endif/*COM_FILTER_LOWPASS_H*/
