/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup common_operators
 * \defgroup extract_band Extract one band of an image
 */
/**
 * \ingroup extract_band
 * \file com_extract_band.h
 * \author Flavien Vernier
 * 
 * \brief operator of extraction of band.
 * 
 * file includes (stucture, prototype de fonction) of the operator extract_band
 * 
 * 
 */

#ifndef COM_EXTRACT_BAND_H
#define COM_EXTRACT_BAND_H

#include <stdlib.h>
#include <string.h>
#include "efidir_image.h"
#include "efidir_goodies.h"
#include "efidir_param.h"

/**
 * \ingroup extract_band
 * \typedef Extract_band_param
 *
 * \brief reference on extract_band_param structure
 *
 */
/**
 * \ingroup extract_band
 * \struct extract_band_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_extract_band_param{
  int band; /*!< band to be extracted of the image */
}extract_band_param, *Extract_band_param;

/**
 * \ingroup extract_band
 * \fn new_extract_band_param()
 *
 * \return A new reference on allocated extract_band_param structure
 *
 * \brief Create a new Extract_band_param reference 
 *
 */
static Extract_band_param new_extract_band_param();
/**
 * \ingroup extract_band
 * \fn free_extract_band_param(Extract_band_param p)
 *
 * \param p A reference on a extract_band_param structure
 *
 * \brief Free an allocated Extract_band_param reference 
 *
 */
void free_extract_band_param(Extract_band_param p);


/**
 * \ingroup extract_band
 * \fn void define_extract_band_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_extract_band_param(char *extra_description);

/**
 * \ingroup extract_band
 * \fn Extract_band_param get_extract_band_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Extract_band_param that contains the parameters.
 */
Extract_band_param get_extract_band_param();

/**
 * \ingroup extract_band
 * \fn void extract_band(Extract_band_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief function of extraction of band
 * Function allowing to extract one of the bands of an image multi-band.
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the multi-band image from which we want to extract a band
 * \param outputImage is the result of extract_band operation
 *
 */
void extract_band(Extract_band_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);


#endif
