/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup com_resize_image
 * \defgroup enlarge Enlarge an image
 */
/**
 * \ingroup enlarge
 * \file com_enlarge.h
 * \author Yajing Yan
 * 
 * \brief operator to resize(enlarge) the image
 * 
 * file includes (stucture, prototype de fonction) of the operator enlarge
 * 
 * 
 */

#ifndef COM_ENLARGE_H
#define COM_ENLARGE_H

#include <stdlib.h>
#include <string.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup enlarge
 * \typedef Enlarge_param
 *
 * \brief reference on enlarge_param structure
 *
 */
/**
 * \ingroup enlarge
 * \struct enlarge_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_enlarge_param
{
  int l; /*!< number of lines of the resized image */
  int c; /*!< number of columns of the resized image */
  int dl; /*!< shift of lines */
  int dc; /*!< shift of columns */
  int type; /*!< geometry type, 1 for LAT/LON, 2 for UTM */
}enlarge_param, *Enlarge_param;

/**
 * \ingroup enlarge
 * \fn new_enlarge_param()
 *
 * \return A new reference on allocated enlarge_param structure
 *
 * \brief Create a new Enlarge_param reference 
 *
 */
static Enlarge_param new_enlarge_param();
/**
 * \ingroup enlarge
 * \fn free_enlarge_param(Enlarge_param p)
 *
 * \param p A reference on a enlarge_param structure
 *
 * \brief Free an allocated Enlarge_param reference 
 *
 */
void free_enlarge_param(Enlarge_param p);


/**
 * \ingroup enlarge
 * \fn void define_enlarge_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_enlarge_param(char *extra_description);

/**
 * \ingroup enlarge
 * \fn Enlarge_param get_enlarge_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Enlarge_param that contains the parameters.
 */
Enlarge_param get_enlarge_param();

/**
 * \ingroup enlarge
 * \fn void enlarge(Enlarge_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage, EFIDIRImage outputMask);
 * \brief function to resize the image
 * Function allowing to resize the image
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the image to resize
 * \param inputMask is the mask of the image to resize
 * \param outputImage is the result of enlarge operation
 * \param outputMask is the mask of the resized image
 *
 */
void enlarge(Enlarge_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage, EFIDIRImage outputMask);


#endif
