/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup com_math_tools
 * \defgroup eigenvalue calculate the eigenvalue of matrix
 */
/**
 * \ingroup eigenvalue
 * \file com_eigenvalue.h
 * \author Yajing Yan
 * 
 * \brief operator of calculating the eigenvalue of matrix
 * 
 * file includes (stucture, prototype de fonction) of the operator eigenvalue
 * 
 * 
 */

#ifndef COM_EIGENVALUE_H
#define COM_EIGENVALUE_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_matrix_op.h"

/**
 * \ingroup eigenvalue
 * \fn void max_eigenvalue(float **A, int dim, float *X, double e, float lambda, float *V);
 * \brief function of calculating the maximum eigenvalue of matrix
 * Function for computing the maximum eigenvalue of matrix 
 *
 * \param A is the matrix whose eigenvalue we  look for
 * \param dim is the size of matrix A
 * \param X is a random vector who helps to calculate the eigenvalue 
 * \param e is the threshold for the iteration
 * \param lambda is the maximum eigenvalue 
 * \param V is the eigenvector corresponding to lambda
 *
 */
void max_eigenvalue(float **A, int dim, float *X, double e, float lambda, float *V);

/**
 * \ingroup eigenvalue
 * \fn void min_eigenvalue(float **A, int dim, float *X, double e, float lambda, float *V);
 * \brief function of calculating the minimum eigenvalue of matrix
 * Function for computing the minimum eigenvalue of matrix 
 *
 * \param A is the matrix whose eigenvalue we  look for
 * \param dim is the size of matrix A
 * \param X is a random vector who helps to calculate the eigenvalue 
 * \param e is the threshold for the iteration
 * \param lambda is the minimum eigenvalue 
 * \param V is the eigenvector corresponding to lambda
 *
 */
void min_eigenvalue(float **A, int dim, float *X, double e, float lambda, float *V);

/*
 * \ingroup eigenvalue
 * \fn void jacobien_eigenvalue(float **A, int dim, double e, float *lambda, float **V);
 * \brief function of calculating the eigenvalues of matrix
 * Function for computing the eigenvalues of matrix 
 *
 * \param A is the matrix whose eigenvalue we  look for
 * \param dim is the size of matrix A
 * \param e is the threshold for the iteration
 * \param lambda is the eigenvalues
 * \param V is the eigenvectors corresponding to lambda
 *
 */
void jacobien_eigenvalue(float **A, int dim, double e, float *lambda, float **V);


#endif
