/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_CROP_SERIES_H
#define COM_CROP_SERIES_H

#include "efidir_image.h"
#include "efidir_image_list.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include "com_crop.h"
#include <stdlib.h> 

/**
 * \ingroup series
 * \defgroup crop_series Crop_series an image
 */
/**
 * \ingroup crop_series
 * \typedef Crop_series_param
 * \author Flavien Vernier (LISTIC)
 *
 * \brief reference on crop_series_param structure
 *
 */

/**
 * \ingroup crop_series
 * \struct crop_series_param
 *
 * \brief structure that contains the parameters of the operator crop_series
 *
 */
 typedef struct struct_crop_series_param{
   Crop_param crop_param; /*!< The crop parameters for single image */
   int firstImage;              /*!< First image of the list to compute */
   int lastImage;               /*!< Last image of the list to compute */
 }crop_series_param, *Crop_series_param;



/**
 * \ingroup crop_series
 * \fn Crop_series_param new_crop_series_param()
 *
 * \return A new reference on allocated crop_series_param structure
 *
 * \brief Create a new Crop_series_param reference 
 *
 */
Crop_series_param new_crop_series_param();
/**
 * \ingroup crop_series
 * \fn free_crop_series_param(Crop_series_param p)
 *
 * \param p A reference on a crop_series_param structure
 *
 * \brief Free an allocated Crop_series_param reference 
 *
 */
void free_crop_series_param(Crop_series_param p);

/**
 * \ingroup crop_series
 * \fn void define_crop_series_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_crop_series_param(char *extra_description);
/**
 * \ingroup crop_series
 * \fn Crop_series_param get_crop_series_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Crop_series_param that contains the parameters.
 */
Crop_series_param get_crop_series_param();

/**
 * \ingroup crop_series
 * \fn void crop_series(Crop_series_param p, EFIDIRListImage inputImage, EFIDIRListImage outputImage);
 * \brief Crop_series an image
 * The crop_series operator extracts a window given by a top left point and the size of the window.
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage Image to be croped. Image data can be not loaded.
 * \param outputImage is the image of result
 *
 */
void crop_series(Crop_series_param p, EFIDIRListImage inputImage, EFIDIRListImage outputImage);

#endif /* CROP_SERIES_H */
