/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_CROP_H
#define COM_CROP_H

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include <stdlib.h> 

/**
 * \ingroup com_resize_image
 * \defgroup crop Crop an image
 */
/**
 * \ingroup crop
 * \typedef Crop_param
 * \author Flavien Vernier (LISTIC)
 *
 * \brief reference on crop_param structure
 *
 */

/**
 * \ingroup crop
 * \struct crop_param
 *
 * \brief structure that contains the parameters of the operator crop
 *
 */
typedef struct struct_crop_param{
  int r; /*!< left top row */
  int c; /*!< left top column */
  int nb_r; /*!< number of rows */
  int nb_c; /*!< number of columns */
  int type; /*!< geographic system type */
}crop_param, *Crop_param;

enum GeographicSystemType {
  NO_TYPE=0,
  LAT_LON=1,
  UTM=2,
};
/**
 * \ingroup crop
 * \fn new_crop_param()
 *
 * \return A new reference on allocated crop_param structure
 *
 * \brief Create a new Crop_param reference 
 *
 */
Crop_param new_crop_param();
/**
 * \ingroup crop
 * \fn free_crop_param(Crop_param p)
 *
 * \param p A reference on a crop_param structure
 *
 * \brief Free an allocated Crop_param reference 
 *
 */
void free_crop_param(Crop_param p);

/**
 * \ingroup crop
 * \fn void define_crop_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_crop_param(char *extra_description);
/**
 * \ingroup crop
 * \fn Crop_param get_crop_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Crop_param that contains the parameters.
 */
Crop_param get_crop_param();

/**
 * \ingroup crop
 * \fn void crop(Crop_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief Crop an image
 * The crop operator extracts a window given by a top left point and the size of the window.
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage Image to be cropped. Image data can be not loaded.
 * \param outputImage is the image of result
 *
 */
void crop(Crop_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);

#endif /* CROP_H */
