/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef COM_CONVERT_NAN_ZERO_H
#define COM_CONVERT_NAN_ZERO_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup convert_nan_zero
 * \typedef Convert_nan_zero_param
 *
 * \brief reference on convert_nan_zero_param structure
 *
 */
/**
 * \ingroup convert_nan_zero
 * \struct convert_nan_zero_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_convert_nan_zero_param{
  int choice; /*!< the convertion choice (0:zero->nan - 1: nan->zero) */
}convert_nan_zero_param, *Convert_nan_zero_param;


/**
 * \ingroup convert_nan_zero
 * \fn Convert_nan_zero_param new_convert_nan_zero_param()
 *
 * \return A new reference on allocated convert_nan_zero_param structure
 *
 * \brief Create a new Convert_nan_zero_param reference 
 *
 */
static Convert_nan_zero_param new_convert_nan_zero_param();
/**
 * \ingroup convert_nan_zero
 * \fn void free_convert_nan_zero_param(Convert_nan_zero_param p)
 *
 * \param p A reference on a convert_nan_zero_param structure
 *
 * \brief Free an allocated Convert_nan_zero_param reference 
 *
 */
void free_convert_nan_zero_param(Convert_nan_zero_param p);


/**
 * \ingroup convert_nan_zero
 * \fn void define_convert_nan_zero_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_convert_nan_zero_param(char *extra_description);

/**
 * \ingroup convert_nan_zero
 * \fn Convert_nan_zero_param get_convert_nan_zero_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Convert_nan_zero_param that contains the parameters.
 */
Convert_nan_zero_param get_convert_nan_zero_param();

/**
 * \ingroup convert_nan_zero
 * \fn void convert_nan_zero(Convert_nan_zero_param p,EFIDIRImage inputImage,EFIDIRImage outputImage);
 * \brief function of replace ignored value
 * Function replacing the ignored value. There are thwo possibilities, replacing 0 with nan or replacing nan with 0
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the input image
 * \param outputImage is the output image
 *
 */
 void convert_nan_zero(Convert_nan_zero_param p,EFIDIRImage inputImage,EFIDIRImage outputImage);

#endif //COM_CONVERT_NAN_ZERO_H
