/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

#ifndef COM_CONVERT_DATATYPE_H
#define COM_CONVERT_DATATYPE_H

#include "efidir_image.h"
#include "efidir_param.h"
#include "com_cal_slc.h"
#include "com_statistics.h"

/**
 * \ingroup convert_operators
 * \defgroup convert_datatype Convert image data type
 */


/**
 * \ingroup convert_datatype
 * \struct Convert_datatype_param
 *
 * \brief Type that defines the parameters of the operator convert_datatype
 * 
 */
typedef struct Convert_datatype_param{
  int conversion; /**< Optional paramater for complex values  conversion (\see cal_slc) and phase unwrapping */
}convert_datatype_param, *Convert_datatype_param;

/**
 * \ingroup convert_datatype
 * \fn new_convert_datatype_param()
 *
 * \return A new reference on allocated convert_datatype_param structure
 *
 * \brief Create a new Convert_datatype_param reference 
 *
 */
Convert_datatype_param new_convert_datatype_param();
/**
 * \ingroup convert_datatype
 * \fn free_convert_datatype_param(Convert_datatype_param p)
 *
 * \param p A reference on a convert_datatype_param structure
 *
 * \brief Free an allocated Convert_datatype_param reference 
 *
 */
void free_convert_datatype_param(Convert_datatype_param p);

/**
 * \ingroup convert_datatype
 * \fn void define_convert_datatype_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_convert_datatype_param(char *extra_description);
/**
 * \ingroup convert_datatype
 * \fn Convert_datatype_param get_convert_datatype_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Convert_datatype_param that contains the parameters.
 */
Convert_datatype_param get_convert_datatype_param();

/**
 * \ingroup convert_datatype
 * \fn void convert_datatype(Convert_datatype_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief Convert an image from one type to another
 * The convert_datatype operator converts the image data type
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage Image to be converted. Image data can be not loaded.
 * \param outputImage is the image of result
 *
 */
void convert_datatype(Convert_datatype_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);

#endif /* CONVERT_DATATYPE_H */
