/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_CAL_MASK_H
#define COM_CAL_MASK_H

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include <stdlib.h> 

/**
 * \ingroup common_operators
 * \defgroup cal_mask Switch the mask value
 */
/**
 * \ingroup cal_mask
 * \typedef Cal_mask_param
 * \author Flavien Vernier
 *
 * \brief reference on cal_mask_param structure
 *
 */

/**
 * \ingroup cal_mask
 * \struct cal_mask_param
 *
 * \brief structure that contains the parameters of the operator cal_mask
 *
 */
typedef struct struct_cal_mask_param{
  int processing; /*!< processing index */
  float threshold; /*!< threshold for thresholding and binarize */
}cal_mask_param, *Cal_mask_param;

/**
 * \ingroup cal_mask
 * \fn new_cal_mask_param()
 *
 * \return A new reference on allocated cal_mask_param structure
 *
 * \brief Create a new Cal_mask_param reference 
 *
 */
static Cal_mask_param new_cal_mask_param();
/**
 * \ingroup cal_mask
 * \fn free_cal_mask_param(Cal_mask_param p)
 *
 * \param p A reference on a cal_mask_param structure
 *
 * \brief Free an allocated Cal_mask_param reference 
 *
 */
void free_cal_mask_param(Cal_mask_param p);

/**
 * \ingroup cal_mask
 * \fn void define_cal_mask_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_cal_mask_param(char *extra_description);
/**
 * \ingroup cal_mask
 * \fn Cal_mask_param get_cal_mask_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Cal_mask_param that contains the parameters.
 */
Cal_mask_param get_cal_mask_param();

/**
 * \ingroup cal_mask
 * \fn void cal_mask(Cal_mask_param p, EFIDIRImage inputImage, EFIDIRImage inputImage2, EFIDIRImage outputImage);
 * \brief Processing the mask values
 *
 * Function allowing 
 *   - to switch the mask value, as the convention of mask is not uniform in EFIDIR Tools
 *   - convert image to mask according threshold
 *   - process union, intersection on masks
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the input mask
 * \param inputImage2 optional image depending of operation
 * \param outputImage is the output mask
 *
 */
void cal_mask(Cal_mask_param p, EFIDIRImage inputImage, EFIDIRImage inputImage2, EFIDIRImage outputImage);

#endif
