/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup common_operators
 * \defgroup amplitude_intensity_image Convertion of intensity image into amplitude image and vice versa 
 */
/**
 * \ingroup amplitude_intensity_image
 * \file com_amplitude_intensity_image.h
 * \author Renaud Fallourd
 * 
 * \brief operator of converting intensity image into amplitude image and vice versa
 * 
 * file includes (stucture, prototype of function) of operator amplitude_intensity_image
 * 
 * 
 */


#ifndef COM_AMPLITUDE_INTENSITY_IMAGE_H
#define COM_AMPLITUDE_INTENSITY_IMAGE_H

#include <stdlib.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup amplitude_intensity_image
 * \struct Amplitude_intensity_image_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct Amplitude_intensity_image_param{
  int choice; /*!< choice index*/
}amplitude_intensity_image_param, *Amplitude_intensity_image_param;

/**
 * \ingroup amplitude_intensity_image
 * \fn new_amplitude_intensity_image_param()
 *
 * \return A new reference on allocated amplitude_intensity_image_param structure
 *
 * \brief Create a new Amplitude_intensity_image_param reference 
 *
 */
Amplitude_intensity_image_param new_amplitude_intensity_image_param();

/**
 * \ingroup amplitude_intensity_image
 * \fn free_amplitude_intensity_image_param(Amplitude_intensity_image_param p)
 *
 * \param p A reference on a amplitude_intensity_image_param structure
 *
 * \brief Free an allocated Amplitude_intensity_image_param reference 
 *
 */
void free_amplitude_intensity_image_param(Amplitude_intensity_image_param p);


/**
 * \ingroup amplitude_intensity_image
 * \fn void define_amplitude_intensity_image_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_amplitude_intensity_image_param(char *extra_description);

/**
 * \ingroup amplitude_intensity_image
 * \fn Amplitude_intensity_image_param get_amplitude_intensity_image_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Amplitude_intensity_imagege_param that contains the parameters.
 */
Amplitude_intensity_image_param get_amplitude_intensity_image_param();

/**
 * \ingroup amplitude_intensity_image
 * \fn void amplitude_intensity_image(Amplitude_intensity_image_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief function of converting intensity image into amplitude image and vice versa
 * Function converting intensity image into amplitude image and vice versa
 *
 * \param p is the structure parameter for the operator
 * \param inputImage is the input amplitude/intensity image
 * \param outputImage is the output intensity/amplitude image
 */
void amplitude_intensity_image(Amplitude_intensity_image_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);

#endif /* COM_AMPLITUDE_INTENSITY_IMAGE_H */
