#!/usr/bin/env python

import os
import shutil
import sys
from PIL import Image


def get_date_taken(path):
    return Image.open(path)._getexif()[36867]
    

# Given a time and a list of intervals, find the interval which belongs to the time
def find_time_interval(time, intervals):
    ftr = [3600, 60]
    time_sec = sum([a * b for a, b in zip(ftr, map(int, time.split(':')))])
    i = 0
    for interval in intervals:
        times = interval.split(';')
        time_low = times[0]
        time_high = times[1]
        time_low_sec = sum([a * b for a, b in zip(ftr, map(int, time_low.split(':')))])
        time_high_sec = sum([a * b for a, b in zip(ftr, map(int, time_high.split(':')))])
        
        if(time_low_sec <= time_sec and time_sec < time_high_sec):
            return i
        
        i = i +1
    return -1
        
def get_interval_name(interval):
    return interval.replace(";", "_").replace(":", "").rstrip() 


# Parameters
if (len(sys.argv) != 4):
    print( "Usage: " + sys.argv[0] + " path_images path_output time_file")
    exit(1)
else:
    path = sys.argv[1]
    output_path = sys.argv[2]
    fileName = sys.argv[3]
    
if not os.path.exists(path):
    print("The input path doesn't exist: " + path)
    exit(1)
    
if not os.path.isfile(fileName):
    print("The path to the hour file doesn't exist: " + fileName)
    exit(1)

        
# Get all the time intervals
with open(fileName, "r") as f:
    hours = []
    for line in f:
        hours.append(line)
        
# Create new folder for each interval
for interval in hours:
    interval_name = get_interval_name(interval)
    interval_path = output_path + interval_name + "/"
    if not os.path.exists(interval_path):
        os.makedirs(interval_path)
        
        
if not os.path.exists(output_path + "other/"):
    os.makedirs(output_path + "other/")
        
# Get all images 
paths = [os.path.join(path, fn) for fn in next(os.walk(path))[2]]
paths_images = []
for result in paths:
    idxPoint = 0
    for i in range(len(result) - 1, 0, -1):
        if(result[i] == '.' and idxPoint == 0):
            idxPoint = i
	    
    extension = result[idxPoint:]
    if (extension ==  ".JPG"):
        paths_images.append(result)
        
# Copy each image in the corresponding time interval folder
for image in paths_images:
    date_time = get_date_taken(image)
    time = date_time.split(' ')[1][:5]
    print(time)
    interval_idx = find_time_interval(time, hours)
    if(i != -1):
        path_root = output_path + get_interval_name(hours[interval_idx]) + "/"
    else:
        path_root = output_path + "other/"
    
    # Extract the file name 
    idxSlash = 0
    for i in range(len(image) - 1, 0, -1):
        if(image[i] == '/' and idxSlash == 0):
            idxSlash = i
	    
    fileName = image[idxSlash + 1::]

    shutil.copy(image, path_root + fileName)
    





