#!/usr/bin/env python

import os
import glob
import sys
import shutil
from PIL import Image
 
from efidir.sws import *
from efidir.utils import *
from efidir.config import *
from efidir.param import *
from efidir.utils import listimage

def get_date_taken(path):
    return Image.open(path)._getexif()[36867]

def listFileNameDiff(a, b):
    c=[]
    for fileName in b:
        c.append(os.path.basename(fileName).rstrip("\n"))
    c = set(c)
    return [aa for aa in a if os.path.basename(aa) not in c]


# def genListImage(directory, extention, listName):
#     fileNames = []
#     # Selects the directory to work with
#     os.walk(directory)
#     # Scans for files using the glob module with the following rules, anyfilename with the ".extention" extension

#     for name in glob.glob(directory+"/*"+extention):
#         fileNames.append(name)

#     fileNames.sort()

#     try:
#         f = open(directory+"/"+listName, "r")
#         oldFileNames=[]
#         for name in f:
#             oldFileNames.append(name.rstrip("\n"))
#         f.close()
        
#         oldFileNames.sort()

#         d1 = listFileNameDiff(oldFileNames, fileNames)
#         d2 = listFileNameDiff(fileNames, oldFileNames)


#         if len(d1)!=0 or len(d2)!=0:
           
#             f = open(directory+"/"+listName, "w")
#             for name in fileNames:
#                 f.write(os.path.basename(name))
#                 f.write("\n")
#             f.close()

#     except IOError:

#         f = open(directory+"/"+listName, "w")
#         for name in fileNames:
#             f.write(os.path.basename(name))
#             f.write("\n")
#         f.close()

#     return fileNames;

# Parameters
define_param("path_images", STRING, "Path to the images", None)
define_param("path_output", STRING, "Path where the results are stored. The path will be created if needed", None)
define_param("path_roi", STRING, "Path to the file where the static region are : two points per line, first point is the top left point of the static region and the second point is the bottom right point", None)
define_param("intercorrelation_mode", INT, "Step between two displacement computation", None)
define_param("master", INT, "Index of the master image", None)
init_param(sys.argv)
path = get_string_value_param("path_images")
output_path = get_string_value_param("path_output")
path_roi = get_string_value_param("path_roi")
intercorrelation_mode = get_int_value_param("intercorrelation_mode")
idx_master_image = get_int_value_param("master")

if not os.path.isfile(path_roi): 
    print("The input roi file does not exist : " + path_roi)
    exit(1)

if not os.path.exists(path):
    print("The input path doesn't exist: " + path)
    exit(1)

# Folder which contains the images
#path = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/3_APN1_031013/JPG/730_830/"
# Folder where the results are stored
#output_path = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/3_APN1_031013/JPG/730_830_results_test_filesystem/"
#path_roi = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/3_APN1_031013/coord_keypoints.txt"


##############################################################################
############################ Check Images ####################################
##############################################################################

# Get all the file names inside the folder
paths_images = [os.path.join(path, fn) for fn in next(os.walk(path))[2]]

# Target list to be built
targets = []
if not os.path.exists(output_path):
    os.makedirs(output_path)

XML_path = os.path.join(output_path, "XML")
if not os.path.exists(XML_path):
    os.makedirs(XML_path)

selected_images_path = os.path.join(output_path, "selected_images")
if not os.path.exists(selected_images_path):
    os.makedirs(selected_images_path)

non_selected_images_path = os.path.join(output_path, "non_selected_images/")
if not os.path.exists(non_selected_images_path ):
    os.makedirs(non_selected_images_path )
    
# For each image check if it can be used and write it in a XML file
for image in paths_images:
    
    # Extract the file name and the extension to build the path of the output image
    idxPoint = 0
    idxSlash = 0
    for i in range(len(image) - 1, 0, -1):
        if(image[i] == '.' and idxPoint == 0):
            idxPoint = i
        if(image[i] == '/' and idxSlash == 0):
            idxSlash = i
	    
    fileName = image[idxSlash + 1 : idxPoint]
    extension = image[idxPoint:]

    out = os.path.join(XML_path, fileName + ".XML")#output_path + "XML/" +fileName + ".XML"
        

    #...
    outputs = [
        out]
    
    inputs = [
        image,
        output_path]
    
    commands = [
            "check_image"
                + " " + inputs[0]
                + " " + inputs[1]]
                  
    targets.append(target_create(commands, inputs, outputs))
    
    
print("Start selection")
chain = workflow_create("check.mk", targets)
workflowrun(chain)

print("End selection")

# Write information from selected images
#selected_images = [os.path.join(output_path + "selected_images/", fn) for fn in next(os.walk(output_path + "selected_images/"))[2]]
selected_images = [os.path.join(selected_images_path, fn) for fn in next(os.walk(selected_images_path))[2]]
print(selected_images)
f = open(os.path.join(selected_images_path, "selection.csv"), 'w')
f.write("Image name, date_time\n"); 

for image in selected_images:
    idxPoint = 0
    idxSlash = 0
    for i in range(len(image) - 1, 0, -1):
        if(image[i] == '.' and idxPoint == 0):
            idxPoint = i
        if(image[i] == '/' and idxSlash == 0):
            idxSlash = i
        
    extension = image[idxPoint:]
    fileName = image[idxSlash + 1 : idxPoint]
    if(extension == ".JPG"):
        f.write(fileName + "," + get_date_taken(image) + "\n");
f.close();
    

# Write information from non-selected images
#non_selected_images = [os.path.join(output_path + "non_selected_images/", fn) for fn in next(os.walk(output_path + "non_selected_images/"))[2]]
non_selected_images = [os.path.join(non_selected_images_path, fn) for fn in next(os.walk(non_selected_images_path))[2]]
f = open(os.path.join(non_selected_images_path, "selection.csv"), 'w')
f.write("Image name, date_time\n"); 

for image in non_selected_images:
    idxPoint = 0
    idxSlash = 0
    for i in range(len(image) - 1, 0, -1):
        if(image[i] == '.' and idxPoint == 0):
            idxPoint = i
        if(image[i] == '/' and idxSlash == 0):
            idxSlash = i
    extension = image[idxPoint:]
    fileName = image[idxSlash + 1 : idxPoint]
    if(extension == ".JPG"):
        f.write(fileName + "," + get_date_taken(image) + "\n");
f.close();
    

##############################################################################
############################ Registration ####################################
##############################################################################

selected_images = [os.path.join(selected_images_path, fn) for fn in next(os.walk(selected_images_path))[2]]

# Select the reference for the registration step
image_ref = selected_images[idx_master_image]  

registered_image_path = os.path.join(output_path, "registered_image")
if not os.path.exists(registered_image_path):
    os.makedirs(registered_image_path)

debug_registered_image_path = os.path.join(registered_image_path, "debug")
if not os.path.exists(debug_registered_image_path):
    os.makedirs(debug_registered_image_path)
    
# Copy the reference image to the registered images folder
idxPoint = 0
idxSlash = 0
for i in range(len(image_ref) - 1, 0, -1):
    if(image_ref[i] == '.' and idxPoint == 0):
        idxPoint = i
    if(image_ref[i] == '/' and idxSlash == 0):
        idxSlash = i
	    
fileName = image_ref[idxSlash + 1 : idxPoint]
#dst = output_path + "registered_image/" +fileName + ".JPG"
dst = os.path.join(registered_image_path, fileName + ".JPG")
    
shutil.copy2(image_ref, dst)
    
targets = []
for image in selected_images:
    idxPoint = 0
    idxSlash = 0
    for i in range(len(image) - 1, 0, -1):
        if(image[i] == '.' and idxPoint == 0):
            idxPoint = i
        if(image[i] == '/' and idxSlash == 0):
            idxSlash = i
    extension = image[idxPoint:]
    fileName = image[idxSlash + 1 : idxPoint]
    
    if(image != image_ref and extension == ".JPG"):

        # Extract the file name and the extension to build the path of the output image
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
	    
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        #out = output_path + "registered_image/" + fileName + "_R" + extension
        out = os.path.join(registered_image_path, fileName + "_R" + extension)

        #...
        outputs = [
                out]
        inputs = [
                image_ref,
                image,
                registered_image_path,
                path_roi]
        commands = [
                "image_registration"
                    + " " + inputs[0]
                    + " " + inputs[1]
                    + " " + inputs[2]
                    + " " + inputs[3]]
                  
        targets.append(target_create(commands, inputs, outputs))

chain = workflow_create("process.mk", targets)
workflowsave(chain, "process.mk")
workflowrun(chain)



# Get the result filenames and store it in a text file
#paths_images = [os.path.join(output_path + "registered_image/", fn) for fn in next(os.walk(output_path + "registered_image/"))[2]]
paths_images = [os.path.join(registered_image_path, fn) for fn in next(os.walk(registered_image_path))[2]]
paths_images_registered = []
result_file = open(output_path + "filenames.txt", "w");
for result in paths_images:
        idxPoint = 0
        for i in range(len(result) - 1, 0, -1):
            if(result[i] == '.' and idxPoint == 0):
                idxPoint = i
	    
        extension = result[idxPoint:]
        if (extension ==  ".JPG"):
            result_file.write("%s\n" % result)
            paths_images_registered.append(result)
            
result_file.close





##############################################################################
########################## Convert to float ##################################
##############################################################################

output_float_path = os.path.join(output_path, "float")
if not os.path.exists(output_float_path):
    os.makedirs(output_float_path)
 

#paths_images_lpl = [os.path.join(output_path + "laplacian/", fn) for fn in next(os.walk(output_path + "laplacian/"))[2]]
targets = []
for image in paths_images_registered: 
    
                # Extract the file name and the extension to build the path of the output image
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
	    
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        out = os.path.join(output_float_path,  fileName + ".float")
        

        inputs = [image]
	
        outputs = [out]

        commands = [
                    "convert_datatype "
                            +"  --input "+inputs[0]		 
                            +"  --output "+outputs[0]		
                            +"  --output_datatype 4 "
                    ]
        targets.append(target_create(commands, inputs, outputs))
        
chain = workflow_create("convert.mk", targets)
workflowsave(chain, "convert.mk")
workflowrun(chain)

# Get all the float images and store it in a file

paths_images_float = [os.path.join(output_float_path, fn) for fn in next(os.walk(output_float_path))[2]]
result_file = open(os.path.join(output_float_path, "filenames.list"), "w");
for image in paths_images_float:
    
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
                
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        
        if (extension ==  ".float" and fileName != "filenames"):
            result_file.write("%s\n" % image)
        
result_file.close


listimage.genListImage(output_float_path, ".float", "images.list")


##############################################################################
######################### Compute 2D displacements ###########################
##############################################################################

targets = []

displacements_path = os.path.join(output_path, "displacements")
if not os.path.exists(displacements_path):
    os.makedirs(displacements_path)

inputs = [os.path.join(output_float_path, "images.list")]
outputs = [os.path.join(displacements_path, "filenames.corr")]

if(intercorrelation_mode == 1):
    mode = "1"
elif(intercorrelation_mode == 2):
    mode = "2"
elif(intercorrelation_mode == 3):
    mode = "3"
elif(intercorrelation_mode == 4):
    mode = "4"
elif(intercorrelation_mode == 5):
    mode = "5"
elif(intercorrelation_mode == 10):
    mode = "10"
else:
    mode = "1"
    
commands = [
		"#dist_corr_series "                        
		+"  --input_file_name " + inputs[0]		 
		+"  --output_suffix .corr" 
 		+"  --output_dir " + displacements_path
                +"  --window_nb_rows 33"
		+"  --window_nb_columns 33"
		+"  --window_search_nb_rows 53"
		+"  --window_search_nb_columns 53"
		+"  --sub_pixel 3"	 
		+"  --intercorrelation_mode " + mode

		]
targets.append(target_create(commands, inputs, outputs))

chain = workflow_create("displacements.mk", targets)
workflowsave(chain, "displacements.mk")
workflowrun(chain)



    





