#!/usr/bin/env python

import os
import glob
import sys

from efidir.sws import *
from efidir.utils import *
from efidir.config import *
from efidir.param import *

# Parameters

define_param("path_images", STRING, "Path to the images (need to have the same structure as the result of the process step", None)
define_param("glacier", STRING, "Text file with the glacier coordinates ", None)
init_param(sys.argv)
output_path = get_string_value_param("path_images")
glacier = get_string_value_param("glacier")

# Folder which contains the images

# "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/3_APN1_031013/JPG/730_830_results_10rc2nl/"
#path = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/4_APN1_121213/jpg1/"
# Folder where the results are stored
#output_path = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/4_APN1_121213/result1/"

if not os.path.exists(output_path):
    print("The input path doesn't exist: " + output_path)
    exit(1)


# Get the list of images after the correlation step
paths_images = [os.path.join(output_path + "displacements/", fn) for fn in next(os.walk(output_path + "displacements/"))[2]]
path_images_corr = []
for image in paths_images:
    
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
                
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        
        if (extension ==  ".float" and fileName != "filenames"):
            path_images_corr.append(image);
        

if not os.path.exists(output_path + "error/"):
    os.makedirs(output_path + "error/")


if not os.path.isfile(glacier):
    print("The glacier coordinates files doesn't exist")
    exit(1)


targets = []

for image in path_images_corr:
            # Extract the file name and the extension to build the path of the output image
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
	    
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        out = output_path + "error/" + fileName + ".txt"
        
        inputs = [image, glacier]
            
        outputs = [out]

        commands = [
                    "get_error "
                            +"  --displacement "+inputs[0]
                            +"  --output "+outputs[0]		
                            +"  --glacier " + inputs[1]
                    ]
        targets.append(target_create(commands, inputs, outputs))
        
        
        
chain = workflow_create("error.mk", targets)
workflowsave(chain, "error.mk")
workflowrun(chain)


paths_errors = [os.path.join(output_path + "error/", fn) for fn in next(os.walk(output_path + "error/"))[2]]

sum_x = 0.0;
sum_y = 0.0;
sum_norm = 0.0;
nb = 0.0;
for error in paths_errors:
    if(error != output_path + "error/errors.txt"):
        nb += 1.0
        f = open(error)
        str_x = f.readline()
        sum_x += float(str_x.split(':')[1])
        
        str_y = f.readline()
        sum_y += float(str_y.split(':')[1])
        
        f.readline()
        f.readline()
        f.readline()
        f.readline()
        
        str_norm = f.readline()
        sum_norm += float(str_norm.split(':')[1])
        f.close()

f = open(output_path + "error/errors.txt", 'w')
f.write("Error x : " + str(sum_x / nb) + "\n")
f.write("Error y : " + str(sum_y / nb) + "\n")
f.write("Error norm : " + str(sum_norm / nb) + "\n")
f.close()


if not os.path.exists(output_path + "error_corrected/"):
    os.makedirs(output_path + "error_corrected/")

targets = []
j = 0
for image in path_images_corr:
    
        if(paths_errors[j] == output_path + "error/errors.txt"):
            j += 1
            # Extract the file name and the extension to build the path of the output image
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
	    
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        out = output_path + "error_corrected/" + fileName + ".float"
        
        inputs = [image, paths_errors[j]]
            
        outputs = [out]

        commands = [
                    "correct_error "
                            +"  --displacement "+inputs[0]
                            +"  --output "+outputs[0]		
                            +"  --error " + inputs[1]
                    ]
        targets.append(target_create(commands, inputs, outputs))
        j += 1
        
        
        
chain = workflow_create("error_correction.mk", targets)
workflowsave(chain, "error_correction.mk")
workflowrun(chain)


# Get the list of images after the correlation step
paths_images = [os.path.join(output_path + "error_corrected/", fn) for fn in next(os.walk(output_path + "error_corrected/"))[2]]
path_images_corr = []
for image in paths_images:
    
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
                
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        
        if (extension ==  ".float" and fileName != "filenames"):
            path_images_corr.append(image);
        

# Get the registered images
paths_registered = [os.path.join(output_path + "registered_image/", fn) for fn in next(os.walk(output_path + "registered_image/"))[2]]
paths_images_registered = []
for result in paths_registered:
        idxPoint = 0
        for i in range(len(result) - 1, 0, -1):
            if(result[i] == '.' and idxPoint == 0):
                idxPoint = i
	    
        extension = result[idxPoint:]
        if (extension ==  ".JPG"):
            paths_images_registered.append(result)
            
# Draw arrows on the registered images with the result of the correlation step
if not os.path.exists(output_path + "arrows_corrected/"):
    os.makedirs(output_path + "arrows_corrected/")
    
targets = []
j = 0
for image in path_images_corr:
            # Extract the file name and the extension to build the path of the output image
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
	    
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        out = output_path + "arrows_corrected/" + fileName + ".JPG"
        
        j = j + 1
        if(j < len(paths_images_registered)):
            print( str(j) + "\n")
            print(paths_images_registered[j] + "\n")
            inputs = [paths_images_registered[j], image]
            
            outputs = [out]
            print(out)

            commands = [
                        "draw_arrow "
                                +"  --input "+inputs[0]
                                +"  --displacement "+inputs[1]
                                +"  --scale 10" 
                                +"  --output "+outputs[0]		
                                +"  --caption t1 "
                        ]
            targets.append(target_create(commands, inputs, outputs))
        
        
        
chain = workflow_create("arrows.mk", targets)
workflowsave(chain, "arrows.mk")
workflowrun(chain)
