#!/usr/bin/env python

import os
import glob
import sys

from efidir.sws import *
from efidir.utils import *
from efidir.config import *
from efidir.param import *

# Parameters

define_param("path_images", STRING, "Path to the images (need to have the same structure as the result of the process step", None)

init_param(sys.argv)
output_path = get_string_value_param("path_images")

# Folder which contains the images
#path = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/4_APN1_121213/jpg1/"
# Folder where the results are stored
#output_path = "/home/marsyg/listic_mastodons/marsyg/LAURICHARD/SUIVI/DATA/APN1/4_APN1_121213/result1/"

if not os.path.exists(output_path):
    print("The input path doesn't exist: " + output_path)
    exit(1)


# Get the list of images after the correlation step
paths_images = [os.path.join(output_path + "displacements/", fn) for fn in next(os.walk(output_path + "displacements/"))[2]]
path_images_corr = []
for image in paths_images:
    
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
                
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        
        if (extension ==  ".float" and fileName != "filenames"):
            path_images_corr.append(image);
        

# Get the registered images
paths_registered = [os.path.join(output_path + "registered_image/", fn) for fn in next(os.walk(output_path + "registered_image/"))[2]]
paths_images_registered = []
for result in paths_registered:
        idxPoint = 0
        for i in range(len(result) - 1, 0, -1):
            if(result[i] == '.' and idxPoint == 0):
                idxPoint = i
	    
        extension = result[idxPoint:]
        if (extension ==  ".JPG"):
            paths_images_registered.append(result)
            
# Draw arrows on the registered images with the result of the correlation step
if not os.path.exists(output_path + "arrows/"):
    os.makedirs(output_path + "arrows/")
    
targets = []
j = 0
for image in path_images_corr:
            # Extract the file name and the extension to build the path of the output image
        idxPoint = 0
        idxSlash = 0
        for i in range(len(image) - 1, 0, -1):
            if(image[i] == '.' and idxPoint == 0):
                idxPoint = i
            if(image[i] == '/' and idxSlash == 0):
                idxSlash = i
	    
        fileName = image[idxSlash + 1 : idxPoint]
        extension = image[idxPoint:]
        out = output_path + "arrows/" + fileName + ".JPG"
        
        j = j + 1
        if(j < len(paths_images_registered)):
            print( str(j) + "\n")
            print(paths_images_registered[j] + "\n")
            inputs = [paths_images_registered[j], image]
            
            outputs = [out]
            print(out)

            commands = [
                        "draw_arrow "
                                +"  --input "+inputs[0]
                                +"  --displacement "+inputs[1]
                                +"  --scale 5" 
                                +"  --output "+outputs[0]		
                                +"  --caption t1 "
                        ]
            targets.append(target_create(commands, inputs, outputs))
        
        
        
chain = workflow_create("convert.mk", targets)
workflowsave(chain, "convert.mk")
workflowrun(chain)

