#!/usr/bin/env python

import glob
import os
import re
import sys

from efidir.config import *
from efidir.sws import *
from efidir.utils import *


def usage():
    print "usage:"
    print "      " + sys.argv[0] + " inputDir " + " inputFileExt"
    print ""
    print "      inputDir: input directory that contains all input files"
    print "      inputFileExt: extension of input file (supported by \"convert\" command)"
    print "                    for exemple: .jpg"
    print ""


# check the number of argument"
if len(sys.argv) < 3:
    print "Not enough arguments"
    print "" 
    usage()
    sys.exit()
elif len(sys.argv) > 3:
    print "Not many arguments"
    print "" 
    usage()
    sys.exit()

inputDir = sys.argv[1]
inputExt = sys.argv[2]
inputFiles = []
inputFileOfInputFiles = "images.list"

# Target list to be built
targets = []

# Generate the list image of 
inputFiles = genListImage(inputDir, inputExt, inputFileOfInputFiles)

# 1. Convert image in grey png
greyDir="GREY"
greyExt=".png"

for img in inputFiles:
    outputs = [
        greyDir+"/"+img+greyExt
        ]
    inputs = [
        img
        ]
    commands = [
        "convert"
        +"   "+inputs[0]
        +"   -colorspace Gray"
        +"   "+outputs[0]
        ]
    targets.append(target_create(commands, inputs, outputs))

chain = workflow_create("Correlation_series_optic_grey.mk", targets)
workflowrun(chain)
targets = []

# 1.2 generate list of png
genListImage(greyDir, greyExt, "grey.list")

# 1.3
for n in inputFiles:
         outputs = ["resized25/"+n+".png"]
         inputs = [greyDir+"/"+n+".png"]
         commands = [
 		"convert "
                +" "+ inputs[0]
                +"  -verbose"
                +"  -resize 25%"
                +"  -quality 100%"
                +"  -comment \"proud made with EFIDIR Chain\""
                +" "+ outputs[0]
 		]
         targets.append(target_create(commands, inputs, outputs))

chain = workflow_create("Correlation_series_optic_grey.mk", targets)
workflowrun(chain)
targets = []

# 1.4 generate list of png
genListImage("resized25", ".png", "resized.list")


# 2. convert png images in float images for correlation
inputs=["resized25/resized.list"]
outputs=["FLOAT/resized.list.float"]
commands = ["convert_datatype_series "
            +"   --input "+inputs[0]
            +"   --output_suffix .float"
            +"   --output_dir FLOAT"
            +"   --output_datatype 4"
            ]
targets.append(target_create(commands, inputs, outputs))

# 3. compute point of interest and matching point from grey image
# 3.1 resize images for sift
 
# for n in inputFiles:
#         outputs = ["resized50/"+n+".png"]
# 	inputs = [n+".png"]
# 	commands = [
# 		"convert "
# 		        +" "+ inputs[0]
#                         +"  -verbose"
#                         +"  -resize 50%"
#                         +"  -quality 100%"
#                         +"  -comment \"proud made with EFIDIR Chain\""
#                         +" "+ outputs[0]
# 		]
#         targets.append(target_create(commands, inputs, outputs))

# 3.2 compute sift

# 4. registrate images
# inputs=["FLOAT/grey.list.float",
#         "FLOAT/grey.list.float.POI"]
# outputs=["REGISTRATION/grey.list.float.reg"]
# commands = [
#     EFIDIR_PREFIX+"/bin/registration_series"
#     +"  --input_file_name "+inputs[0]		 
#     +"  --output_suffix .reg"
#     +"  --output_dir REGISTRATION"
#     +"  --file_of_POI_files "+inputs[1]
#     ]

# targets.append(target_create(commands, inputs, outputs))
# 5. correlate image i with i+1

#inputs=["REGISTRATION/grey.list.float.reg"]
inputs=["FLOAT/resized.list.float"]
outputs=["CORRELATION/resized.list.float.corr"]
commands = [
    EFIDIR_PREFIX+"/bin/dist_corr_series "
    +"  --input_file_name "+inputs[0]		 
    +"  --output_suffix .corr" 
    +"  --output_dir CORRELATION"
    +"  --window_nb_rows 33" 
    +"  --window_nb_columns 33"	 
    +"  --window_search_nb_rows 53"	 
    +"  --window_search_nb_columns 53" 
    +"  --sub_pixel 3"	 
    +"  --intercorrelation_mode 1"
    
    ]
targets.append(target_create(commands, inputs, outputs))

# 5. Project latitude, longitude and elevation in SAR geometry

chain = workflow_create("Correlation_series_optic_main.mk", targets)
workflowrun(chain)
