# - Find Oyranos
# Find the native Oyranos headers and libraries.
#
#  OYRANOS_FOUND        - True if Oyranos found.
#  OYRANOS_INCLUDE_DIRS - where to find kdb.h, etc.
#  OYRANOS_LIBRARIES    - List of libraries when using Oyranos.
#  OYRANOS_LIBRARY_DIRS - where to find libraries
#
#  OYRANOS_VERSION       - The version of oyranos (x.y.z)
#  OYRANOS_VERSION_MAJOR - The major version of oyranos (x)
#  OYRANOS_VERSION_MINOR - The minor version of oyranos (y)
#  OYRANOS_VERSION_MICRO - The patch version of oyranos (z)
#
#  OYRANOS_CMM_SUBDIR    - usually "color/modules"
#  OYRANOS_META_SUBDIR   - usually "oyranos-meta"
#  OYRANOS_CMM_DIR       - Oyranos install prefix / lib+LIBSUFFIX / OYRANOS_CMM_SUBDIR
#  OYRANOS_META_DIR      - similar to the above for meta module(s)
#  OYRANOS_ICC_DIR       - similar to the above for ICC profiles
#  OYRANOS_SETTINGS_DIR  - similar to the above for policy files
#  OYRANOS_FRAMEWORK_LOCALE_DIR - Oyranos locale path inside OyranosCore.framework/Resources/
#  OYRANOS_FRAMEWORK_LOCALE     - OyranosCore.framework  OS X framework containing translations
#  OYRANOS_FRAMEWORK_ICC        - Oyranos.framework      OS X framework containing ICC profiles
#  OYRANOS_LINGUAS       - Oyranos translation languages
#
#  OYRANOS_INCLUDE_DIR         - Include of of the Oyranos.framework Headers path
#  OYRANOS_CONFIG_INCLUDE_DIR  - Include of of the OyranosConfig.framework Headers path
#  OYRANOS_MODULES_INCLUDE_DIR - Include of of the OyranosModules.framework Headers path
#  OYRANOS_OBJECT_INCLUDE_DIR  - Include of of the OyranosObject.framework Headers path
#  OYRANOS_CORE_INCLUDE_DIR    - Include of of the OyranosCore.framework Headers path
#
#  OYRANOS_MODULE_LIBRARIES    - Additional framework install libraries
#
#  OYRANOS_CORE_LIBRARIES      - library for core API
#  OYRANOS_OBJECT_LIBRARIES    - libraries for object API + above
#  OYRANOS_MODULES_LIBRARIES   - libraries for module API + above
#  OYRANOS_CONFIG_LIBRARIES    - libraries for config API + above
#  OYRANOS_LIBRARIES           - libraries for imaging API + above
#
#  OYRANOS_CORE_LIBRARIES_EXTRA    - linked libraries
#  OYRANOS_OBJECT_LIBRARIES_EXTRA  - linked libraries
#  OYRANOS_MODULES_LIBRARIES_EXTRA - linked libraries
#  OYRANOS_CONFIG_LIBRARIES_EXTRA  - linked libraries
#  OYRANOS_LIBRARIES_EXTRA         - linked libraries
#
#  HAVE_OYRANOS          - TRUE



# Set path to the header file.
IF(APPLE)
  FIND_PATH(OYRANOS_INCLUDE_DIR
	NAMES oyranos_profile.h
	PATHS /usr/Library/Frameworks/Oyranos.framework/Headers
	NO_DEFAULT_PATH
  )
  FIND_PATH(OYRANOS_CONFIG_INCLUDE_DIR
	NAMES oyranos_devices.h
	PATHS /usr/Library/Frameworks/OyranosConfig.framework/Headers
	NO_DEFAULT_PATH
  )
  FIND_PATH(OYRANOS_MODULES_INCLUDE_DIR
	NAMES oyranos_module.h
	PATHS /usr/Library/Frameworks/OyranosModules.framework/Headers
	NO_DEFAULT_PATH
  )
  FIND_PATH(OYRANOS_OBJECT_INCLUDE_DIR
	NAMES oyranos_object.h
	PATHS /usr/Library/Frameworks/OyranosObject.framework/Headers
	NO_DEFAULT_PATH
  )
  FIND_PATH(OYRANOS_CORE_INCLUDE_DIR
	NAMES oyranos_core.h
	PATHS /usr/Library/Frameworks/OyranosCore.framework/Headers
	NO_DEFAULT_PATH
  )
ELSE(APPLE)
  FIND_PATH(OYRANOS_INCLUDE_DIR
	NAMES oyranos.h
	PATHS /usr/include/oyranos
	NO_DEFAULT_PATH
  )
ENDIF(APPLE)
MARK_AS_ADVANCED(OYRANOS_INCLUDE_DIR)

# Set path to the library.
FIND_LIBRARY(OYRANOS_CORE_LIBRARY
	NAMES OyranosCore
	PATHS /usr/lib
	NO_DEFAULT_PATH
)
SET( OYRANOS_CORE_LIBRARIES ${OYRANOS_CORE_LIBRARY} )
MARK_AS_ADVANCED(OYRANOS_CORE_LIBRARIES)
FIND_LIBRARY(OYRANOS_OBJECT_LIBRARY
	NAMES OyranosObject
	PATHS /usr/lib
	NO_DEFAULT_PATH
)
SET( OYRANOS_OBJECT_LIBRARIES ${OYRANOS_OBJECT_LIBRARY} ${OYRANOS_CORE_LIBRARY} )
MARK_AS_ADVANCED(OYRANOS_OBJECT_LIBRARIES)
FIND_LIBRARY(OYRANOS_MODULES_LIBRARY
	NAMES OyranosModules
	PATHS /usr/lib
	NO_DEFAULT_PATH
)
SET( OYRANOS_MODULES_LIBRARIES ${OYRANOS_MODULES_LIBRARY} ${OYRANOS_OBJECT_LIBRARY} ${OYRANOS_CORE_LIBRARY} )
MARK_AS_ADVANCED(OYRANOS_MODULES_LIBRARIES)
FIND_LIBRARY(OYRANOS_CONFIG_LIBRARY
	NAMES OyranosConfig
	PATHS /usr/lib
	NO_DEFAULT_PATH
)
SET( OYRANOS_CONFIG_LIBRARIES ${OYRANOS_CONFIG_LIBRARY} ${OYRANOS_MODULES_LIBRARY} ${OYRANOS_OBJECT_LIBRARY} ${OYRANOS_CORE_LIBRARY} )
MARK_AS_ADVANCED(OYRANOS_CONFIG_LIBRARIES)
FIND_LIBRARY(OYRANOS_LIBRARY
	NAMES Oyranos
	PATHS /usr/lib
	NO_DEFAULT_PATH
)
SET( OYRANOS_LIBRARIES ${OYRANOS_LIBRARY} ${OYRANOS_CONFIG_LIBRARY} ${OYRANOS_MODULES_LIBRARY} ${OYRANOS_OBJECT_LIBRARY} ${OYRANOS_CORE_LIBRARY} )
MARK_AS_ADVANCED(OYRANOS_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set OYRANOS_FOUND to TRUE if
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Oyranos DEFAULT_MSG OYRANOS_LIBRARY OYRANOS_INCLUDE_DIR)

if (OYRANOS_FOUND)
        SET( OYRANOS_VERSION_MAJOR 0 )
        SET( OYRANOS_VERSION_MINOR 9 )
        SET( OYRANOS_VERSION_MICRO 6 )
        SET( OYRANOS_VERSION       0.9.6 )
        SET( OYRANOS_CMM_SUBDIR    color/modules )
        SET( OYRANOS_META_SUBDIR   oyranos-meta )
        SET( OYRANOS_CMM_DIR       /usr/lib/color/modules )
        SET( OYRANOS_META_DIR      /usr/lib/oyranos-meta )
        SET( OYRANOS_ICC_DIR       /usr/share/color/icc )
        SET( OYRANOS_SETTINGS_DIR  /usr/share/color/settings )
        SET( OYRANOS_FRAMEWORK_LOCALE_DIR locale )
        SET( OYRANOS_FRAMEWORK_LOCALE     OyranosCore.framework )
        SET( OYRANOS_FRAMEWORK_ICC        Oyranos.framework )
        SET( OYRANOS_MODULE_LIBRARIES     lcms2;raw;stdc++;lcms2;png16;/usr/lib64/libz.so;/usr/lib64/libjpeg.so;Xcm;XcmEDID;XcmDDC;XcmX11;Xfixes;-lpthread;/usr/lib64/libexiv2.so )
        SET( OYRANOS_CORE_LIBRARIES_EXTRA    m )
        SET( OYRANOS_OBJECT_LIBRARIES_EXTRA  m )
        SET( OYRANOS_MODULES_LIBRARIES_EXTRA m m;dl;ltdl;c;/usr/lib64/libgomp.so )
        SET( OYRANOS_CONFIG_LIBRARIES_EXTRA  m m;dl;ltdl;c;/usr/lib64/libgomp.so m;dl;ltdl;c;/usr/lib64/libgomp.so;elektra;elektra-kdb;elektra-core;elektra-ease;elektra-meta;elektra-plugin;elektra-proposal;yajl )
        SET( OYRANOS_LIBRARIES_EXTRA         m m;dl;ltdl;c;/usr/lib64/libgomp.so m;dl;ltdl;c;/usr/lib64/libgomp.so;elektra;elektra-kdb;elektra-core;elektra-ease;elektra-meta;elektra-plugin;elektra-proposal;yajl )
        SET( OYRANOS_LINGUAS       cs;de;eo;eu;fr;ru )
        SET( HAVE_OYRANOS          TRUE )
	SET( OYRANOS_INCLUDE_DIRS
             ${OYRANOS_INCLUDE_DIR}
             ${OYRANOS_CONFIG_INCLUDE_DIR}
             ${OYRANOS_MODULES_INCLUDE_DIR}
             ${OYRANOS_OBJECT_INCLUDE_DIR}
             ${OYRANOS_CORE_INCLUDE_DIR}
           )
        SET( OYRANOS_LIBRARY_DIRS /usr/lib )
endif (OYRANOS_FOUND)
